/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class GetSecretValueRequest
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#GetSecretValueRequest";
    public static final GetSecretValueRequest VOID = new GetSecretValueRequest(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<String> secretId = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> versionId = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> versionStage = Optional.empty();

    public String getSecretId() {
        if (this.secretId.isPresent()) {
            return this.secretId.get();
        }
        return null;
    }

    public void setSecretId(String secretId) {
        this.secretId = Optional.ofNullable(secretId);
    }

    public GetSecretValueRequest withSecretId(String secretId) {
        this.setSecretId(secretId);
        return this;
    }

    public String getVersionId() {
        if (this.versionId.isPresent()) {
            return this.versionId.get();
        }
        return null;
    }

    public void setVersionId(String versionId) {
        this.versionId = Optional.ofNullable(versionId);
    }

    public GetSecretValueRequest withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public String getVersionStage() {
        if (this.versionStage.isPresent()) {
            return this.versionStage.get();
        }
        return null;
    }

    public void setVersionStage(String versionStage) {
        this.versionStage = Optional.ofNullable(versionStage);
    }

    public GetSecretValueRequest withVersionStage(String versionStage) {
        this.setVersionStage(versionStage);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof GetSecretValueRequest)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        GetSecretValueRequest other = (GetSecretValueRequest)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.secretId.equals(other.secretId);
        isEquals = isEquals && this.versionId.equals(other.versionId);
        isEquals = isEquals && this.versionStage.equals(other.versionStage);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.secretId, this.versionId, this.versionStage);
    }
}

