/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.aws.greengrass.model.DeploymentStatus;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class LocalDeployment
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#LocalDeployment";
    public static final LocalDeployment VOID = new LocalDeployment(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<String> deploymentId = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> status = Optional.empty();

    public String getDeploymentId() {
        if (this.deploymentId.isPresent()) {
            return this.deploymentId.get();
        }
        return null;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = Optional.ofNullable(deploymentId);
    }

    public LocalDeployment withDeploymentId(String deploymentId) {
        this.setDeploymentId(deploymentId);
        return this;
    }

    public DeploymentStatus getStatus() {
        if (this.status.isPresent()) {
            return DeploymentStatus.get(this.status.get());
        }
        return null;
    }

    public String getStatusAsString() {
        if (this.status.isPresent()) {
            return this.status.get();
        }
        return null;
    }

    public void setStatus(String status) {
        this.status = Optional.ofNullable(status);
    }

    public LocalDeployment withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(DeploymentStatus status) {
        this.status = Optional.ofNullable(status.getValue());
    }

    public LocalDeployment withStatus(DeploymentStatus status) {
        this.setStatus(status);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof LocalDeployment)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        LocalDeployment other = (LocalDeployment)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.deploymentId.equals(other.deploymentId);
        isEquals = isEquals && this.status.equals(other.status);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.deploymentId, this.status);
    }
}

