/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class MQTTCredential
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#MQTTCredential";
    public static final MQTTCredential VOID = new MQTTCredential(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<String> clientId = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> certificatePem = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> username = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> password = Optional.empty();

    public String getClientId() {
        if (this.clientId.isPresent()) {
            return this.clientId.get();
        }
        return null;
    }

    public void setClientId(String clientId) {
        this.clientId = Optional.ofNullable(clientId);
    }

    public MQTTCredential withClientId(String clientId) {
        this.setClientId(clientId);
        return this;
    }

    public String getCertificatePem() {
        if (this.certificatePem.isPresent()) {
            return this.certificatePem.get();
        }
        return null;
    }

    public void setCertificatePem(String certificatePem) {
        this.certificatePem = Optional.ofNullable(certificatePem);
    }

    public MQTTCredential withCertificatePem(String certificatePem) {
        this.setCertificatePem(certificatePem);
        return this;
    }

    public String getUsername() {
        if (this.username.isPresent()) {
            return this.username.get();
        }
        return null;
    }

    public void setUsername(String username) {
        this.username = Optional.ofNullable(username);
    }

    public MQTTCredential withUsername(String username) {
        this.setUsername(username);
        return this;
    }

    public String getPassword() {
        if (this.password.isPresent()) {
            return this.password.get();
        }
        return null;
    }

    public void setPassword(String password) {
        this.password = Optional.ofNullable(password);
    }

    public MQTTCredential withPassword(String password) {
        this.setPassword(password);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof MQTTCredential)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        MQTTCredential other = (MQTTCredential)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.clientId.equals(other.clientId);
        isEquals = isEquals && this.certificatePem.equals(other.certificatePem);
        isEquals = isEquals && this.username.equals(other.username);
        isEquals = isEquals && this.password.equals(other.password);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.certificatePem, this.username, this.password);
    }
}

