/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.eventstreamrpc.EventStreamRPCServiceModel;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class MQTTMessage
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#MQTTMessage";
    public static final MQTTMessage VOID = new MQTTMessage(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<String> topicName = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<byte[]> payload = Optional.empty();

    public String getTopicName() {
        if (this.topicName.isPresent()) {
            return this.topicName.get();
        }
        return null;
    }

    public void setTopicName(String topicName) {
        this.topicName = Optional.ofNullable(topicName);
    }

    public MQTTMessage withTopicName(String topicName) {
        this.setTopicName(topicName);
        return this;
    }

    public byte[] getPayload() {
        if (this.payload.isPresent()) {
            return this.payload.get();
        }
        return null;
    }

    public void setPayload(byte[] payload) {
        this.payload = Optional.ofNullable(payload);
    }

    public MQTTMessage withPayload(byte[] payload) {
        this.setPayload(payload);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof MQTTMessage)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        MQTTMessage other = (MQTTMessage)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.topicName.equals(other.topicName);
        isEquals = isEquals && EventStreamRPCServiceModel.blobTypeEquals(this.payload, other.payload);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.topicName, this.payload);
    }
}

