/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.aws.greengrass.model.MetricUnitType;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class Metric
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#Metric";
    public static final Metric VOID = new Metric(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<String> name = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> unit = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<Double> value = Optional.empty();

    public String getName() {
        if (this.name.isPresent()) {
            return this.name.get();
        }
        return null;
    }

    public void setName(String name) {
        this.name = Optional.ofNullable(name);
    }

    public Metric withName(String name) {
        this.setName(name);
        return this;
    }

    public MetricUnitType getUnit() {
        if (this.unit.isPresent()) {
            return MetricUnitType.get(this.unit.get());
        }
        return null;
    }

    public String getUnitAsString() {
        if (this.unit.isPresent()) {
            return this.unit.get();
        }
        return null;
    }

    public void setUnit(String unit) {
        this.unit = Optional.ofNullable(unit);
    }

    public Metric withUnit(String unit) {
        this.setUnit(unit);
        return this;
    }

    public void setUnit(MetricUnitType unit) {
        this.unit = Optional.ofNullable(unit.getValue());
    }

    public Metric withUnit(MetricUnitType unit) {
        this.setUnit(unit);
        return this;
    }

    public Double getValue() {
        if (this.value.isPresent()) {
            return this.value.get();
        }
        return null;
    }

    public void setValue(Double value) {
        this.value = Optional.ofNullable(value);
    }

    public Metric withValue(Double value) {
        this.setValue(value);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof Metric)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        Metric other = (Metric)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.name.equals(other.name);
        isEquals = isEquals && this.unit.equals(other.unit);
        isEquals = isEquals && this.value.equals(other.value);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.unit, this.value);
    }
}

