/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.aws.greengrass.model.QOS;
import software.amazon.awssdk.eventstreamrpc.EventStreamRPCServiceModel;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class PublishToIoTCoreRequest
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#PublishToIoTCoreRequest";
    public static final PublishToIoTCoreRequest VOID = new PublishToIoTCoreRequest(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<String> topicName = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> qos = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<byte[]> payload = Optional.empty();

    public String getTopicName() {
        if (this.topicName.isPresent()) {
            return this.topicName.get();
        }
        return null;
    }

    public void setTopicName(String topicName) {
        this.topicName = Optional.ofNullable(topicName);
    }

    public PublishToIoTCoreRequest withTopicName(String topicName) {
        this.setTopicName(topicName);
        return this;
    }

    public QOS getQos() {
        if (this.qos.isPresent()) {
            return QOS.get(this.qos.get());
        }
        return null;
    }

    public String getQosAsString() {
        if (this.qos.isPresent()) {
            return this.qos.get();
        }
        return null;
    }

    public void setQos(String qos) {
        this.qos = Optional.ofNullable(qos);
    }

    public PublishToIoTCoreRequest withQos(String qos) {
        this.setQos(qos);
        return this;
    }

    public void setQos(QOS qos) {
        this.qos = Optional.ofNullable(qos.getValue());
    }

    public PublishToIoTCoreRequest withQos(QOS qos) {
        this.setQos(qos);
        return this;
    }

    public byte[] getPayload() {
        if (this.payload.isPresent()) {
            return this.payload.get();
        }
        return null;
    }

    public void setPayload(byte[] payload) {
        this.payload = Optional.ofNullable(payload);
    }

    public PublishToIoTCoreRequest withPayload(byte[] payload) {
        this.setPayload(payload);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof PublishToIoTCoreRequest)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        PublishToIoTCoreRequest other = (PublishToIoTCoreRequest)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.topicName.equals(other.topicName);
        isEquals = isEquals && this.qos.equals(other.qos);
        isEquals = isEquals && EventStreamRPCServiceModel.blobTypeEquals(this.payload, other.payload);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.topicName, this.qos, this.payload);
    }
}

