/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.eventstreamrpc;

import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class UnmappedDataException
extends RuntimeException {
    public UnmappedDataException(String applicationModelType) {
        super(String.format("Cannot find Java class type for application model type: %s", applicationModelType));
    }

    public UnmappedDataException(Class<? extends EventStreamJsonMessage> expectedClass) {
        super(String.format("Data does not map into Java class: %s", expectedClass.getCanonicalName()));
    }

    public UnmappedDataException(String applicationModelType, Class<? extends EventStreamJsonMessage> expectedClass) {
        super(String.format("Found model-type {%s} which does not map into Java class: %s", applicationModelType, expectedClass.getCanonicalName()));
    }
}

