/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.iot;

import java.io.UnsupportedEncodingException;
import java.util.function.Consumer;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.Log;
import software.amazon.awssdk.crt.auth.credentials.CredentialsProvider;
import software.amazon.awssdk.crt.auth.credentials.DefaultChainCredentialsProvider;
import software.amazon.awssdk.crt.auth.signing.AwsSigningConfig;
import software.amazon.awssdk.crt.http.HttpProxyOptions;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.ClientTlsContext;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.io.TlsContext;
import software.amazon.awssdk.crt.io.TlsContextCustomKeyOperationOptions;
import software.amazon.awssdk.crt.io.TlsContextOptions;
import software.amazon.awssdk.crt.io.TlsContextPkcs11Options;
import software.amazon.awssdk.crt.mqtt.MqttClient;
import software.amazon.awssdk.crt.mqtt.MqttClientConnection;
import software.amazon.awssdk.crt.mqtt.MqttClientConnectionEvents;
import software.amazon.awssdk.crt.mqtt.MqttConnectionConfig;
import software.amazon.awssdk.crt.mqtt.MqttException;
import software.amazon.awssdk.crt.mqtt.MqttMessage;
import software.amazon.awssdk.crt.mqtt.QualityOfService;
import software.amazon.awssdk.crt.mqtt.WebsocketHandshakeTransformArgs;
import software.amazon.awssdk.crt.utils.PackageInfo;
import software.amazon.awssdk.iot.AwsSigv4HandshakeTransformer;

public final class AwsIotMqttConnectionBuilder
extends CrtResource {
    private static String IOT_SIGNING_SERVICE = "iotdevicegateway";
    private static String AMZ_DATE_HEADER = "x-amz-date";
    private static String AMZ_SECURITY_TOKEN_HEADER = "x-amz-security-token";
    MqttConnectionConfig config;
    private MqttClient client;
    private CredentialsProvider websocketCredentialsProvider;
    private String websocketSigningRegion;
    private ClientTlsContext tlsContext;
    private TlsContextOptions tlsOptions;
    private ClientBootstrap bootstrap;
    private boolean resetLazilyCreatedResources = true;
    private boolean isUsingCustomAuthorizer = false;

    private void resetDefaultPort() {
        if (TlsContextOptions.isAlpnSupported()) {
            this.tlsOptions.withAlpnList("x-amzn-mqtt-ca");
            this.config.setPort(443);
        } else {
            this.config.setPort(8883);
        }
    }

    private AwsIotMqttConnectionBuilder(TlsContextOptions tlsOptions) {
        try (MqttConnectionConfig connectionConfig = new MqttConnectionConfig();){
            this.addReferenceTo((CrtResource)connectionConfig);
            this.config = connectionConfig;
        }
        this.tlsOptions = tlsOptions;
        this.addReferenceTo((CrtResource)tlsOptions);
        this.resetDefaultPort();
    }

    protected void releaseNativeHandle() {
    }

    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    public static AwsIotMqttConnectionBuilder newMtlsBuilderFromPath(String certPath, String privateKeyPath) {
        try (TlsContextOptions tlsContextOptions = TlsContextOptions.createWithMtlsFromPath((String)certPath, (String)privateKeyPath);){
            AwsIotMqttConnectionBuilder awsIotMqttConnectionBuilder = new AwsIotMqttConnectionBuilder(tlsContextOptions);
            return awsIotMqttConnectionBuilder;
        }
    }

    public static AwsIotMqttConnectionBuilder newMtlsBuilder(String certificate, String privateKey) {
        try (TlsContextOptions tlsContextOptions = TlsContextOptions.createWithMtls((String)certificate, (String)privateKey);){
            AwsIotMqttConnectionBuilder awsIotMqttConnectionBuilder = new AwsIotMqttConnectionBuilder(tlsContextOptions);
            return awsIotMqttConnectionBuilder;
        }
    }

    public static AwsIotMqttConnectionBuilder newMtlsBuilder(byte[] certificate, byte[] privateKey) throws UnsupportedEncodingException {
        return AwsIotMqttConnectionBuilder.newMtlsBuilder(new String(certificate, "UTF8"), new String(privateKey, "UTF8"));
    }

    public static AwsIotMqttConnectionBuilder newMtlsPkcs11Builder(TlsContextPkcs11Options pkcs11Options) {
        try (TlsContextOptions tlsContextOptions = TlsContextOptions.createWithMtlsPkcs11((TlsContextPkcs11Options)pkcs11Options);){
            AwsIotMqttConnectionBuilder awsIotMqttConnectionBuilder = new AwsIotMqttConnectionBuilder(tlsContextOptions);
            return awsIotMqttConnectionBuilder;
        }
    }

    public static AwsIotMqttConnectionBuilder newMtlsCustomKeyOperationsBuilder(TlsContextCustomKeyOperationOptions operationOptions) {
        try (TlsContextOptions tlsContextOptions = TlsContextOptions.createWithMtlsCustomKeyOperations((TlsContextCustomKeyOperationOptions)operationOptions);){
            AwsIotMqttConnectionBuilder awsIotMqttConnectionBuilder = new AwsIotMqttConnectionBuilder(tlsContextOptions);
            return awsIotMqttConnectionBuilder;
        }
    }

    public static AwsIotMqttConnectionBuilder newMtlsWindowsCertStorePathBuilder(String certificatePath) {
        try (TlsContextOptions tlsContextOptions = TlsContextOptions.createWithMtlsWindowsCertStorePath((String)certificatePath);){
            AwsIotMqttConnectionBuilder awsIotMqttConnectionBuilder = new AwsIotMqttConnectionBuilder(tlsContextOptions);
            return awsIotMqttConnectionBuilder;
        }
    }

    public static AwsIotMqttConnectionBuilder newDefaultBuilder() throws UnsupportedEncodingException {
        try (TlsContextOptions tlsContextOptions = TlsContextOptions.createDefaultClient();){
            AwsIotMqttConnectionBuilder awsIotMqttConnectionBuilder = new AwsIotMqttConnectionBuilder(tlsContextOptions);
            return awsIotMqttConnectionBuilder;
        }
    }

    public AwsIotMqttConnectionBuilder withCertificateAuthorityFromPath(String caDirPath, String caFilePath) {
        this.tlsOptions.overrideDefaultTrustStoreFromPath(caDirPath, caFilePath);
        this.resetLazilyCreatedResources = true;
        return this;
    }

    public AwsIotMqttConnectionBuilder withCertificateAuthority(String caRoot) {
        this.tlsOptions.overrideDefaultTrustStore(caRoot);
        this.resetLazilyCreatedResources = true;
        return this;
    }

    public AwsIotMqttConnectionBuilder withEndpoint(String endpoint) {
        this.config.setEndpoint(endpoint);
        return this;
    }

    public AwsIotMqttConnectionBuilder withPort(short port) {
        this.config.setPort((int)port);
        return this;
    }

    public AwsIotMqttConnectionBuilder withClientId(String clientId) {
        this.config.setClientId(clientId);
        return this;
    }

    public AwsIotMqttConnectionBuilder withCleanSession(boolean cleanSession) {
        this.config.setCleanSession(cleanSession);
        return this;
    }

    @Deprecated
    public AwsIotMqttConnectionBuilder withKeepAliveMs(int keepAliveMs) {
        this.config.setKeepAliveSecs(keepAliveMs / 1000);
        return this;
    }

    public AwsIotMqttConnectionBuilder withKeepAliveSecs(int keepAliveSecs) {
        this.config.setKeepAliveSecs(keepAliveSecs);
        return this;
    }

    public AwsIotMqttConnectionBuilder withPingTimeoutMs(int pingTimeoutMs) {
        this.config.setPingTimeoutMs(pingTimeoutMs);
        return this;
    }

    public AwsIotMqttConnectionBuilder withProtocolOperationTimeoutMs(int protocolOperationTimeoutMs) {
        this.config.setProtocolOperationTimeoutMs(protocolOperationTimeoutMs);
        return this;
    }

    public AwsIotMqttConnectionBuilder withTimeoutMs(int timeoutMs) {
        this.config.getSocketOptions().connectTimeoutMs = timeoutMs;
        return this;
    }

    public AwsIotMqttConnectionBuilder withReconnectTimeoutSecs(long minTimeoutSecs, long maxTimeoutSecs) {
        this.config.setReconnectTimeoutSecs(minTimeoutSecs, maxTimeoutSecs);
        return this;
    }

    public AwsIotMqttConnectionBuilder withSocketOptions(SocketOptions socketOptions) {
        this.config.setSocketOptions(socketOptions);
        return this;
    }

    public AwsIotMqttConnectionBuilder withUsername(String username) {
        this.config.setUsername(username);
        return this;
    }

    public AwsIotMqttConnectionBuilder withPassword(String password) {
        this.config.setPassword(password);
        return this;
    }

    public AwsIotMqttConnectionBuilder withConnectionEventCallbacks(MqttClientConnectionEvents callbacks) {
        this.config.setConnectionCallbacks(callbacks);
        return this;
    }

    public AwsIotMqttConnectionBuilder withWill(MqttMessage message) throws MqttException {
        this.config.setWillMessage(message);
        return this;
    }

    @Deprecated
    public AwsIotMqttConnectionBuilder withWill(MqttMessage message, QualityOfService qos, boolean retain) throws MqttException {
        return this.withWill(new MqttMessage(message.getTopic(), message.getPayload(), qos, retain));
    }

    public AwsIotMqttConnectionBuilder withBootstrap(ClientBootstrap bootstrap) {
        this.swapReferenceTo((CrtResource)this.bootstrap, (CrtResource)bootstrap);
        this.bootstrap = bootstrap;
        this.resetLazilyCreatedResources = true;
        return this;
    }

    public AwsIotMqttConnectionBuilder withWebsockets(boolean useWebsockets) {
        this.config.setUseWebsockets(useWebsockets);
        if (useWebsockets) {
            this.tlsOptions.alpnList.clear();
            this.config.setPort(443);
        } else {
            this.resetDefaultPort();
        }
        this.resetLazilyCreatedResources = true;
        return this;
    }

    public AwsIotMqttConnectionBuilder withWebsocketHandshakeTransform(Consumer<WebsocketHandshakeTransformArgs> handshakeTransform) {
        this.config.setWebsocketHandshakeTransform(handshakeTransform);
        return this;
    }

    public AwsIotMqttConnectionBuilder withWebsocketProxyOptions(HttpProxyOptions proxyOptions) {
        this.config.setHttpProxyOptions(proxyOptions);
        return this;
    }

    public AwsIotMqttConnectionBuilder withHttpProxyOptions(HttpProxyOptions proxyOptions) {
        this.config.setHttpProxyOptions(proxyOptions);
        return this;
    }

    public AwsIotMqttConnectionBuilder withWebsocketSigningRegion(String region) {
        this.websocketSigningRegion = region;
        return this;
    }

    public AwsIotMqttConnectionBuilder withWebsocketCredentialsProvider(CredentialsProvider provider) {
        this.swapReferenceTo((CrtResource)this.websocketCredentialsProvider, (CrtResource)provider);
        this.websocketCredentialsProvider = provider;
        return this;
    }

    private String addUsernameParameter(String inputString, String parameterValue, String parameterPreText, Boolean addedStringToUsername) {
        String return_string = inputString;
        return_string = addedStringToUsername == false ? return_string + "?" : return_string + "&";
        if (parameterValue.contains(parameterPreText)) {
            return return_string + parameterValue;
        }
        return return_string + parameterPreText + parameterValue;
    }

    public AwsIotMqttConnectionBuilder withCustomAuthorizer(String username, String authorizerName, String authorizerSignature, String password) {
        this.isUsingCustomAuthorizer = true;
        String usernameString = "";
        Boolean addedStringToUsername = false;
        if (username == null) {
            if (this.config.getUsername() != null) {
                usernameString = usernameString + this.config.getUsername();
            }
        } else {
            usernameString = usernameString + username;
        }
        if (authorizerName != null) {
            usernameString = this.addUsernameParameter(usernameString, authorizerName, "x-amz-customauthorizer-name=", addedStringToUsername);
            addedStringToUsername = true;
        }
        if (authorizerSignature != null) {
            usernameString = this.addUsernameParameter(usernameString, authorizerSignature, "x-amz-customauthorizer-signature=", addedStringToUsername);
        }
        this.config.setUsername(usernameString);
        if (password != null) {
            this.config.setPassword(password);
        }
        this.config.setPort(443);
        this.tlsOptions.alpnList.clear();
        this.tlsOptions.alpnList.add("mqtt");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MqttClientConnection build() {
        if (this.bootstrap == null) {
            this.bootstrap = ClientBootstrap.getOrCreateStaticDefault();
        }
        AwsIotMqttConnectionBuilder awsIotMqttConnectionBuilder = this;
        synchronized (awsIotMqttConnectionBuilder) {
            Throwable throwable;
            if (!this.isUsingCustomAuthorizer && this.config.getUsername() != null && (this.config.getUsername().contains("x-amz-customauthorizer-name=") || this.config.getUsername().contains("x-amz-customauthorizer-signature="))) {
                this.isUsingCustomAuthorizer = true;
            }
            if (this.isUsingCustomAuthorizer) {
                if (this.config.getPort() != 443) {
                    Log.log((Log.LogLevel)Log.LogLevel.Warn, (Log.LogSubject)Log.LogSubject.MqttClient, (String)"Attempting to connect to authorizer with unsupported port. Port is not 443...");
                }
                if (this.tlsOptions.alpnList.size() == 1) {
                    if (this.tlsOptions.alpnList.get(0) != "mqtt") {
                        this.tlsOptions.alpnList.clear();
                        this.tlsOptions.alpnList.add("mqtt");
                    }
                } else {
                    this.tlsOptions.alpnList.clear();
                    this.tlsOptions.alpnList.add("mqtt");
                }
            }
            if (this.tlsOptions != null && (this.tlsContext == null || this.resetLazilyCreatedResources)) {
                throwable = null;
                try (ClientTlsContext clientTlsContext = new ClientTlsContext(this.tlsOptions);){
                    this.swapReferenceTo((CrtResource)this.tlsContext, (CrtResource)clientTlsContext);
                    this.tlsContext = clientTlsContext;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            if (this.client == null || this.resetLazilyCreatedResources) {
                throwable = null;
                try (MqttClient mqttClient = this.tlsContext == null ? new MqttClient(this.bootstrap) : new MqttClient(this.bootstrap, (TlsContext)this.tlsContext);){
                    this.swapReferenceTo((CrtResource)this.client, (CrtResource)mqttClient);
                    this.client = mqttClient;
                    this.config.setMqttClient(this.client);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
        this.resetLazilyCreatedResources = false;
        try (MqttConnectionConfig connectionConfig = this.config.clone();){
            String usernameOrEmpty = "";
            if (connectionConfig.getUsername() != null) {
                usernameOrEmpty = connectionConfig.getUsername();
            }
            String queryStringConcatenation = "?";
            if (usernameOrEmpty.contains("?")) {
                queryStringConcatenation = "&";
            }
            connectionConfig.setUsername(String.format("%s%sSDK=JavaV2&Version=%s", usernameOrEmpty, queryStringConcatenation, new PackageInfo().version.toString()));
            if (connectionConfig.getUseWebsockets() && connectionConfig.getWebsocketHandshakeTransform() == null) {
                if (this.websocketCredentialsProvider == null) {
                    DefaultChainCredentialsProvider.DefaultChainCredentialsProviderBuilder providerBuilder = new DefaultChainCredentialsProvider.DefaultChainCredentialsProviderBuilder();
                    providerBuilder.withClientBootstrap(this.bootstrap);
                    try (DefaultChainCredentialsProvider defaultProvider = providerBuilder.build();){
                        this.withWebsocketCredentialsProvider((CredentialsProvider)defaultProvider);
                    }
                }
                try (AwsSigningConfig signingConfig = new AwsSigningConfig();){
                    signingConfig.setAlgorithm(AwsSigningConfig.AwsSigningAlgorithm.SIGV4);
                    signingConfig.setSignatureType(AwsSigningConfig.AwsSignatureType.HTTP_REQUEST_VIA_QUERY_PARAMS);
                    signingConfig.setRegion(this.websocketSigningRegion);
                    signingConfig.setService(IOT_SIGNING_SERVICE);
                    signingConfig.setCredentialsProvider(this.websocketCredentialsProvider);
                    signingConfig.setOmitSessionToken(true);
                    try (AwsSigv4HandshakeTransformer transformer = new AwsSigv4HandshakeTransformer(signingConfig);){
                        connectionConfig.setWebsocketHandshakeTransform((Consumer)transformer);
                        connectionConfig.addReferenceTo((CrtResource)transformer);
                    }
                }
            }
            MqttClientConnection mqttClientConnection = new MqttClientConnection(connectionConfig);
            return mqttClientConnection;
        }
    }
}

