/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 *
 * This file is generated.
 */

package software.amazon.awssdk.iot.iotidentity.model;

import java.util.HashMap;

/**
 * Data needed to perform a RegisterThing operation.
 *
 */
public class RegisterThingRequest {

    /**
     * The provisioning template name.
     *
     */
    public String templateName;


    /**
     * The token to prove ownership of the certificate. The token is generated by AWS IoT when you create a certificate over MQTT.
     *
     */
    public String certificateOwnershipToken;


    /**
     * Optional. Key-value pairs from the device that are used by the pre-provisioning hooks to evaluate the registration request.
     *
     */
    public HashMap<String, String> parameters;


}
