/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 *
 * This file is generated.
 */

package software.amazon.awssdk.iot.iotshadow.model;

import software.amazon.awssdk.iot.Timestamp;
import software.amazon.awssdk.iot.iotshadow.model.ShadowMetadata;
import software.amazon.awssdk.iot.iotshadow.model.ShadowStateWithDelta;

/**
 * Response payload to a GetShadow request.
 *
 */
public class GetShadowResponse {

    /**
     * An opaque token used to correlate requests and responses.
     *
     */
    public String clientToken;


    /**
     * The (classic) shadow state of the AWS IoT thing.
     *
     */
    public ShadowStateWithDelta state;


    /**
     * Contains the timestamps for each attribute in the desired and reported sections of the state.
     *
     */
    public ShadowMetadata metadata;


    /**
     * The time the response was generated by AWS IoT.
     *
     */
    public Timestamp timestamp;


    /**
     * The current version of the document for the device's shadow shared in AWS IoT. It is increased by one over the previous version of the document.
     *
     */
    public Integer version;


}
