/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 *
 * This file is generated.
 */

package software.amazon.awssdk.iot.iotshadow.model;

import java.util.HashMap;
import software.amazon.awssdk.iot.Timestamp;

/**
 * An event generated when a shadow document was updated by a request to AWS IoT.  The event payload contains only the changes requested.
 *
 */
public class ShadowDeltaUpdatedEvent {

    /**
     * Shadow properties that were updated.
     *
     */
    public HashMap<String, Object> state;


    /**
     * Timestamps for the shadow properties that were updated.
     *
     */
    public HashMap<String, Object> metadata;


    /**
     * The time the event was generated by AWS IoT.
     *
     */
    public Timestamp timestamp;


    /**
     * The current version of the document for the device's shadow.
     *
     */
    public Integer version;


    /**
     * An opaque token used to correlate requests and responses.  Present only if a client token was used in the request.
     *
     */
    public String clientToken;


}
