/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 *
 * This file is generated.
 */

package software.amazon.awssdk.iot.iotshadow.model;

import software.amazon.awssdk.iot.Timestamp;
import software.amazon.awssdk.iot.iotshadow.model.ShadowUpdatedSnapshot;

/**
 * A description of the before and after states of a device shadow.
 *
 */
public class ShadowUpdatedEvent {

    /**
     * Contains the state of the object before the update.
     *
     */
    public ShadowUpdatedSnapshot previous;


    /**
     * Contains the state of the object after the update.
     *
     */
    public ShadowUpdatedSnapshot current;


    /**
     * The time the event was generated by AWS IoT.
     *
     */
    public Timestamp timestamp;


}
