/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 *
 * This file is generated.
 */

package software.amazon.awssdk.iot.iotshadow.model;

import software.amazon.awssdk.iot.Timestamp;
import software.amazon.awssdk.iot.iotshadow.model.ShadowMetadata;
import software.amazon.awssdk.iot.iotshadow.model.ShadowState;

/**
 * Response payload to an UpdateShadow request.
 *
 */
public class UpdateShadowResponse {

    /**
     * An opaque token used to correlate requests and responses.  Present only if a client token was used in the request.
     *
     */
    public String clientToken;


    /**
     * Updated device shadow state.
     *
     */
    public ShadowState state;


    /**
     * Contains the timestamps for each attribute in the desired and reported sections so that you can determine when the state was updated.
     *
     */
    public ShadowMetadata metadata;


    /**
     * The time the response was generated by AWS IoT. 
     *
     */
    public Timestamp timestamp;


    /**
     * The current version of the document for the device's shadow shared in AWS IoT. It is increased by one over the previous version of the document.
     *
     */
    public Integer version;


}
