/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import software.amazon.awssdk.aws.greengrass.model.MQTTCredential;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class CredentialDocument
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#CredentialDocument";
    private transient UnionMember setUnionMember;
    @Expose(serialize=true, deserialize=true)
    private Optional<MQTTCredential> mqttCredential = Optional.empty();

    public MQTTCredential getMqttCredential() {
        if (this.mqttCredential.isPresent() && this.setUnionMember == UnionMember.MQTT_CREDENTIAL) {
            return this.mqttCredential.get();
        }
        return null;
    }

    public void setMqttCredential(MQTTCredential mqttCredential) {
        if (this.setUnionMember != null) {
            this.setUnionMember.nullify(this);
        }
        this.mqttCredential = Optional.of(mqttCredential);
        this.setUnionMember = UnionMember.MQTT_CREDENTIAL;
    }

    public CredentialDocument withMqttCredential(MQTTCredential mqttCredential) {
        this.setMqttCredential(mqttCredential);
        return this;
    }

    public UnionMember getSetUnionMember() {
        return this.setUnionMember;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public void selfDesignateSetUnionMember() {
        int setCount = 0;
        UnionMember[] members = UnionMember.values();
        for (int memberIdx = 0; memberIdx < UnionMember.values().length; ++memberIdx) {
            if (!members[memberIdx].isPresent(this)) continue;
            ++setCount;
            this.setUnionMember = members[memberIdx];
        }
        if (setCount > 1) {
            throw new IllegalArgumentException("More than one union member set for type: " + this.getApplicationModelType());
        }
    }

    @Override
    public void postFromJson() {
        this.selfDesignateSetUnionMember();
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof CredentialDocument)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        CredentialDocument other = (CredentialDocument)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.mqttCredential.equals(other.mqttCredential);
        isEquals = isEquals && this.setUnionMember.equals((Object)other.setUnionMember);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mqttCredential, this.setUnionMember});
    }

    public static enum UnionMember {
        MQTT_CREDENTIAL("MQTT_CREDENTIAL", obj -> CredentialDocument.access$002(obj, Optional.empty()), obj -> ((CredentialDocument)obj).mqttCredential != null && ((CredentialDocument)obj).mqttCredential.isPresent());

        private String fieldName;
        private Consumer<CredentialDocument> nullifier;
        private Predicate<CredentialDocument> isPresent;

        private UnionMember(String fieldName, Consumer<CredentialDocument> nullifier, Predicate<CredentialDocument> isPresent) {
            this.fieldName = fieldName;
            this.nullifier = nullifier;
            this.isPresent = isPresent;
        }

        void nullify(CredentialDocument obj) {
            this.nullifier.accept(obj);
        }

        boolean isPresent(CredentialDocument obj) {
            return this.isPresent.test(obj);
        }
    }
}

