/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.aws.greengrass.model.MessageContext;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class JsonMessage
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#JsonMessage";
    public static final JsonMessage VOID = new JsonMessage(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<Map<String, Object>> message = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<MessageContext> context = Optional.empty();

    public Map<String, Object> getMessage() {
        if (this.message.isPresent()) {
            return this.message.get();
        }
        return null;
    }

    public void setMessage(Map<String, Object> message) {
        this.message = Optional.ofNullable(message);
    }

    public JsonMessage withMessage(Map<String, Object> message) {
        this.setMessage(message);
        return this;
    }

    public MessageContext getContext() {
        if (this.context.isPresent()) {
            return this.context.get();
        }
        return null;
    }

    public void setContext(MessageContext context) {
        this.context = Optional.ofNullable(context);
    }

    public JsonMessage withContext(MessageContext context) {
        this.setContext(context);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof JsonMessage)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        JsonMessage other = (JsonMessage)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.message.equals(other.message);
        isEquals = isEquals && this.context.equals(other.context);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.message, this.context);
    }
}

