/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.aws.greengrass.model.PublishMessage;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class PublishToTopicRequest
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#PublishToTopicRequest";
    public static final PublishToTopicRequest VOID = new PublishToTopicRequest(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<String> topic = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<PublishMessage> publishMessage = Optional.empty();

    public String getTopic() {
        if (this.topic.isPresent()) {
            return this.topic.get();
        }
        return null;
    }

    public void setTopic(String topic) {
        this.topic = Optional.ofNullable(topic);
    }

    public PublishToTopicRequest withTopic(String topic) {
        this.setTopic(topic);
        return this;
    }

    public PublishMessage getPublishMessage() {
        if (this.publishMessage.isPresent()) {
            return this.publishMessage.get();
        }
        return null;
    }

    public void setPublishMessage(PublishMessage publishMessage) {
        this.publishMessage = Optional.ofNullable(publishMessage);
    }

    public PublishToTopicRequest withPublishMessage(PublishMessage publishMessage) {
        this.setPublishMessage(publishMessage);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof PublishToTopicRequest)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        PublishToTopicRequest other = (PublishToTopicRequest)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.topic.equals(other.topic);
        isEquals = isEquals && this.publishMessage.equals(other.publishMessage);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.publishMessage);
    }
}

