/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.aws.greengrass.model.GreengrassCoreIPCError;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class ResourceNotFoundError
extends GreengrassCoreIPCError
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#ResourceNotFoundError";
    public static final ResourceNotFoundError VOID = new ResourceNotFoundError(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<String> message;
    @Expose(serialize=true, deserialize=true)
    private Optional<String> resourceType;
    @Expose(serialize=true, deserialize=true)
    private Optional<String> resourceName;

    public ResourceNotFoundError(String errorMessage) {
        super("ResourceNotFoundError", errorMessage);
        this.message = Optional.ofNullable(errorMessage);
        this.resourceType = Optional.empty();
        this.resourceName = Optional.empty();
    }

    public ResourceNotFoundError() {
        super("ResourceNotFoundError", "");
        this.message = Optional.empty();
        this.resourceType = Optional.empty();
        this.resourceName = Optional.empty();
    }

    @Override
    public String getErrorTypeString() {
        return "client";
    }

    @Override
    public String getMessage() {
        if (this.message.isPresent()) {
            return this.message.get();
        }
        return null;
    }

    public void setMessage(String message) {
        this.message = Optional.ofNullable(message);
    }

    public ResourceNotFoundError withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public String getResourceType() {
        if (this.resourceType.isPresent()) {
            return this.resourceType.get();
        }
        return null;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = Optional.ofNullable(resourceType);
    }

    public ResourceNotFoundError withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public String getResourceName() {
        if (this.resourceName.isPresent()) {
            return this.resourceName.get();
        }
        return null;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = Optional.ofNullable(resourceName);
    }

    public ResourceNotFoundError withResourceName(String resourceName) {
        this.setResourceName(resourceName);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof ResourceNotFoundError)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        ResourceNotFoundError other = (ResourceNotFoundError)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.message.equals(other.message);
        isEquals = isEquals && this.resourceType.equals(other.resourceType);
        isEquals = isEquals && this.resourceName.equals(other.resourceName);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.message, this.resourceType, this.resourceName);
    }
}

