/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class SystemResourceLimits
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#SystemResourceLimits";
    public static final SystemResourceLimits VOID = new SystemResourceLimits(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<Long> memory = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<Double> cpus = Optional.empty();

    public Long getMemory() {
        if (this.memory.isPresent()) {
            return this.memory.get();
        }
        return null;
    }

    public void setMemory(Long memory) {
        this.memory = Optional.ofNullable(memory);
    }

    public SystemResourceLimits withMemory(Long memory) {
        this.setMemory(memory);
        return this;
    }

    public Double getCpus() {
        if (this.cpus.isPresent()) {
            return this.cpus.get();
        }
        return null;
    }

    public void setCpus(Double cpus) {
        this.cpus = Optional.ofNullable(cpus);
    }

    public SystemResourceLimits withCpus(Double cpus) {
        this.setCpus(cpus);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof SystemResourceLimits)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        SystemResourceLimits other = (SystemResourceLimits)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.memory.equals(other.memory);
        isEquals = isEquals && this.cpus.equals(other.cpus);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.memory, this.cpus);
    }
}

