/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.eventstreamrpc;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.ClientTlsContext;
import software.amazon.awssdk.crt.io.EventLoopGroup;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.eventstreamrpc.MessageAmendInfo;

public class EventStreamRPCConnectionConfig {
    private final ClientBootstrap clientBootstrap;
    private final EventLoopGroup eventLoopGroup;
    private final SocketOptions socketOptions;
    private final ClientTlsContext tlsContext;
    private final String host;
    private final int port;
    private final Supplier<CompletableFuture<MessageAmendInfo>> connectMessageAmender;

    public EventStreamRPCConnectionConfig(ClientBootstrap clientBootstrap, EventLoopGroup eventLoopGroup, SocketOptions socketOptions, ClientTlsContext tlsContext, String host, int port, Supplier<CompletableFuture<MessageAmendInfo>> connectMessageAmender) {
        this.clientBootstrap = clientBootstrap;
        this.eventLoopGroup = eventLoopGroup;
        this.socketOptions = socketOptions;
        this.tlsContext = tlsContext;
        this.host = host;
        this.port = port;
        this.connectMessageAmender = connectMessageAmender;
        if (clientBootstrap == null || eventLoopGroup == null || socketOptions == null || host == null || host.isEmpty()) {
            throw new IllegalArgumentException("EventStreamRPCConnectionConfig values are invalid!");
        }
    }

    public ClientBootstrap getClientBootstrap() {
        return this.clientBootstrap;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public ClientTlsContext getTlsContext() {
        return this.tlsContext;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Supplier<CompletableFuture<MessageAmendInfo>> getConnectMessageAmender() {
        return this.connectMessageAmender;
    }
}

