/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.iot.discovery;

import com.google.gson.Gson;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.crt.http.HttpClientConnection;
import software.amazon.awssdk.crt.http.HttpClientConnectionManager;
import software.amazon.awssdk.crt.http.HttpClientConnectionManagerOptions;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpStream;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandler;
import software.amazon.awssdk.crt.io.TlsContextOptions;
import software.amazon.awssdk.iot.discovery.DiscoveryClientConfig;
import software.amazon.awssdk.iot.discovery.model.DiscoverResponse;

public class DiscoveryClient
implements AutoCloseable {
    public static final String TLS_EXT_ALPN = "x-amzn-http-ca";
    private static final String HTTP_HEADER_REQUEST_ID = "x-amzn-RequestId";
    private static final String HTTP_HEADER_ERROR_TYPE = "x-amzn-ErrorType";
    private static final String AWS_DOMAIN_DEFAULT = "amazonaws.com";
    private static final Map<String, String> AWS_DOMAIN_SUFFIX_MAP = new HashMap<String, String>();
    private static final Gson GSON;
    private final HttpClientConnectionManager httpClientConnectionManager;
    private ExecutorService executorService = null;
    private boolean cleanExecutor = false;

    public DiscoveryClient(DiscoveryClientConfig config) {
        this.executorService = config.getDiscoveryExecutor();
        if (this.executorService == null) {
            this.executorService = Executors.newFixedThreadPool(1);
            this.cleanExecutor = true;
        }
        this.httpClientConnectionManager = HttpClientConnectionManager.create((HttpClientConnectionManagerOptions)new HttpClientConnectionManagerOptions().withClientBootstrap(config.getBootstrap()).withProxyOptions(config.getProxyOptions()).withSocketOptions(config.getSocketOptions()).withMaxConnections(config.getMaxConnections()).withTlsContext(config.getTlsContext()).withUri(URI.create("https://" + DiscoveryClient.getHostname(config))).withPort(TlsContextOptions.isAlpnSupported() ? 443 : 8443));
    }

    public CompletableFuture<DiscoverResponse> discover(String thingName) {
        if (thingName == null) {
            throw new IllegalArgumentException("ThingName cannot be null!");
        }
        return CompletableFuture.supplyAsync(() -> {
            try (HttpClientConnection connection = (HttpClientConnection)this.httpClientConnectionManager.acquireConnection().get();){
                DiscoverResponse discoverResponse;
                block18: {
                    String requestHttpPath = "/greengrass/discover/thing/" + thingName;
                    HttpHeader[] headers = new HttpHeader[]{new HttpHeader("host", this.httpClientConnectionManager.getUri().getHost())};
                    HttpRequest request = new HttpRequest("GET", requestHttpPath, headers, null);
                    final CompletableFuture responseComplete = new CompletableFuture();
                    final StringBuilder jsonBodyResponseBuilder = new StringBuilder();
                    final HashMap responseInfo = new HashMap();
                    HttpStream stream = connection.makeRequest(request, new HttpStreamResponseHandler(){

                        public void onResponseHeaders(HttpStream stream, int responseStatusCode, int blockType, HttpHeader[] httpHeaders) {
                            Arrays.stream(httpHeaders).forEach(header -> responseInfo.put(header.getName(), header.getValue()));
                        }

                        public int onResponseBody(HttpStream stream, byte[] bodyBytes) {
                            jsonBodyResponseBuilder.append(new String(bodyBytes, StandardCharsets.UTF_8));
                            return bodyBytes.length;
                        }

                        public void onResponseComplete(HttpStream httpStream, int errorCode) {
                            responseComplete.complete(errorCode);
                        }
                    });
                    try {
                        stream.activate();
                        responseComplete.get();
                        if (stream.getResponseStatusCode() != 200) {
                            throw new RuntimeException(String.format("Error %s(%d); RequestId: %s", HTTP_HEADER_ERROR_TYPE, stream.getResponseStatusCode(), HTTP_HEADER_REQUEST_ID));
                        }
                        String responseString = jsonBodyResponseBuilder.toString();
                        discoverResponse = (DiscoverResponse)GSON.fromJson((Reader)new StringReader(responseString), DiscoverResponse.class);
                        if (stream == null) break block18;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    stream.close();
                }
                return discoverResponse;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }, this.executorService);
    }

    private static String getHostname(DiscoveryClientConfig config) {
        if (config.getGGServerName().equals("")) {
            return String.format("greengrass-ats.iot.%s.%s", config.getRegion(), AWS_DOMAIN_SUFFIX_MAP.getOrDefault(config.getRegion(), AWS_DOMAIN_DEFAULT));
        }
        return String.format(config.getGGServerName(), new Object[0]);
    }

    @Override
    public void close() {
        if (this.httpClientConnectionManager != null) {
            this.httpClientConnectionManager.close();
        }
        if (this.cleanExecutor) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException ie) {
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        this.executorService = null;
    }

    static {
        AWS_DOMAIN_SUFFIX_MAP.put("cn-north-1", "amazonaws.com.cn");
        AWS_DOMAIN_SUFFIX_MAP.put("cn-northwest-1", "amazonaws.com.cn");
        AWS_DOMAIN_SUFFIX_MAP.put("us-isob-east-1", "sc2s.sgov.gov");
        AWS_DOMAIN_SUFFIX_MAP.put("us-iso-east-1", "c2s.ic.gov");
        GSON = new Gson();
    }
}

