/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.iot.iotjobs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.crt.mqtt.MqttClientConnection;
import software.amazon.awssdk.crt.mqtt.MqttException;
import software.amazon.awssdk.crt.mqtt.MqttMessage;
import software.amazon.awssdk.crt.mqtt.QualityOfService;
import software.amazon.awssdk.iot.EnumSerializer;
import software.amazon.awssdk.iot.Timestamp;
import software.amazon.awssdk.iot.iotjobs.model.DescribeJobExecutionRequest;
import software.amazon.awssdk.iot.iotjobs.model.DescribeJobExecutionResponse;
import software.amazon.awssdk.iot.iotjobs.model.DescribeJobExecutionSubscriptionRequest;
import software.amazon.awssdk.iot.iotjobs.model.GetPendingJobExecutionsRequest;
import software.amazon.awssdk.iot.iotjobs.model.GetPendingJobExecutionsResponse;
import software.amazon.awssdk.iot.iotjobs.model.GetPendingJobExecutionsSubscriptionRequest;
import software.amazon.awssdk.iot.iotjobs.model.JobExecutionsChangedEvent;
import software.amazon.awssdk.iot.iotjobs.model.JobExecutionsChangedSubscriptionRequest;
import software.amazon.awssdk.iot.iotjobs.model.JobStatus;
import software.amazon.awssdk.iot.iotjobs.model.NextJobExecutionChangedEvent;
import software.amazon.awssdk.iot.iotjobs.model.NextJobExecutionChangedSubscriptionRequest;
import software.amazon.awssdk.iot.iotjobs.model.RejectedError;
import software.amazon.awssdk.iot.iotjobs.model.RejectedErrorCode;
import software.amazon.awssdk.iot.iotjobs.model.StartNextJobExecutionResponse;
import software.amazon.awssdk.iot.iotjobs.model.StartNextPendingJobExecutionRequest;
import software.amazon.awssdk.iot.iotjobs.model.StartNextPendingJobExecutionSubscriptionRequest;
import software.amazon.awssdk.iot.iotjobs.model.UpdateJobExecutionRequest;
import software.amazon.awssdk.iot.iotjobs.model.UpdateJobExecutionResponse;
import software.amazon.awssdk.iot.iotjobs.model.UpdateJobExecutionSubscriptionRequest;

public class IotJobsClient {
    private MqttClientConnection connection = null;
    private final Gson gson = this.getGson();

    public IotJobsClient(MqttClientConnection connection) {
        this.connection = connection;
    }

    private Gson getGson() {
        GsonBuilder gson = new GsonBuilder();
        gson.disableHtmlEscaping();
        gson.registerTypeAdapter(Timestamp.class, (Object)new Timestamp.Serializer());
        gson.registerTypeAdapter(Timestamp.class, (Object)new Timestamp.Deserializer());
        this.addTypeAdapters(gson);
        return gson.create();
    }

    private void addTypeAdapters(GsonBuilder gson) {
        gson.registerTypeAdapter(RejectedErrorCode.class, new EnumSerializer());
        gson.registerTypeAdapter(JobStatus.class, new EnumSerializer());
    }

    public CompletableFuture<Integer> PublishDescribeJobExecution(DescribeJobExecutionRequest request, QualityOfService qos) {
        String topic = "$aws/things/{thingName}/jobs/{jobId}/get";
        if (request.thingName == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("DescribeJobExecutionRequest must have a non-null thingName"));
            return result;
        }
        topic = topic.replace("{thingName}", request.thingName);
        if (request.jobId == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("DescribeJobExecutionRequest must have a non-null jobId"));
            return result;
        }
        topic = topic.replace("{jobId}", request.jobId);
        String payloadJson = this.gson.toJson((Object)request);
        MqttMessage message = new MqttMessage(topic, payloadJson.getBytes(StandardCharsets.UTF_8));
        return this.connection.publish(message, qos, false);
    }

    public CompletableFuture<Integer> PublishGetPendingJobExecutions(GetPendingJobExecutionsRequest request, QualityOfService qos) {
        String topic = "$aws/things/{thingName}/jobs/get";
        if (request.thingName == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("GetPendingJobExecutionsRequest must have a non-null thingName"));
            return result;
        }
        topic = topic.replace("{thingName}", request.thingName);
        String payloadJson = this.gson.toJson((Object)request);
        MqttMessage message = new MqttMessage(topic, payloadJson.getBytes(StandardCharsets.UTF_8));
        return this.connection.publish(message, qos, false);
    }

    public CompletableFuture<Integer> PublishStartNextPendingJobExecution(StartNextPendingJobExecutionRequest request, QualityOfService qos) {
        String topic = "$aws/things/{thingName}/jobs/start-next";
        if (request.thingName == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("StartNextPendingJobExecutionRequest must have a non-null thingName"));
            return result;
        }
        topic = topic.replace("{thingName}", request.thingName);
        String payloadJson = this.gson.toJson((Object)request);
        MqttMessage message = new MqttMessage(topic, payloadJson.getBytes(StandardCharsets.UTF_8));
        return this.connection.publish(message, qos, false);
    }

    public CompletableFuture<Integer> PublishUpdateJobExecution(UpdateJobExecutionRequest request, QualityOfService qos) {
        String topic = "$aws/things/{thingName}/jobs/{jobId}/update";
        if (request.thingName == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("UpdateJobExecutionRequest must have a non-null thingName"));
            return result;
        }
        topic = topic.replace("{thingName}", request.thingName);
        if (request.jobId == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("UpdateJobExecutionRequest must have a non-null jobId"));
            return result;
        }
        topic = topic.replace("{jobId}", request.jobId);
        String payloadJson = this.gson.toJson((Object)request);
        MqttMessage message = new MqttMessage(topic, payloadJson.getBytes(StandardCharsets.UTF_8));
        return this.connection.publish(message, qos, false);
    }

    public CompletableFuture<Integer> SubscribeToDescribeJobExecutionAccepted(DescribeJobExecutionSubscriptionRequest request, QualityOfService qos, Consumer<DescribeJobExecutionResponse> handler, Consumer<Exception> exceptionHandler) {
        String topic = "$aws/things/{thingName}/jobs/{jobId}/get/accepted";
        if (request.thingName == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("DescribeJobExecutionSubscriptionRequest must have a non-null thingName"));
            return result;
        }
        topic = topic.replace("{thingName}", request.thingName);
        if (request.jobId == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("DescribeJobExecutionSubscriptionRequest must have a non-null jobId"));
            return result;
        }
        topic = topic.replace("{jobId}", request.jobId);
        Consumer<MqttMessage> messageHandler = message -> {
            block2: {
                try {
                    String payload = new String(message.getPayload(), StandardCharsets.UTF_8);
                    DescribeJobExecutionResponse response = (DescribeJobExecutionResponse)this.gson.fromJson(payload, DescribeJobExecutionResponse.class);
                    handler.accept(response);
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block2;
                    exceptionHandler.accept(e);
                }
            }
        };
        return this.connection.subscribe(topic, qos, messageHandler);
    }

    public CompletableFuture<Integer> SubscribeToDescribeJobExecutionAccepted(DescribeJobExecutionSubscriptionRequest request, QualityOfService qos, Consumer<DescribeJobExecutionResponse> handler) {
        return this.SubscribeToDescribeJobExecutionAccepted(request, qos, handler, null);
    }

    public CompletableFuture<Integer> SubscribeToDescribeJobExecutionRejected(DescribeJobExecutionSubscriptionRequest request, QualityOfService qos, Consumer<RejectedError> handler, Consumer<Exception> exceptionHandler) {
        String topic = "$aws/things/{thingName}/jobs/{jobId}/get/rejected";
        if (request.thingName == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("DescribeJobExecutionSubscriptionRequest must have a non-null thingName"));
            return result;
        }
        topic = topic.replace("{thingName}", request.thingName);
        if (request.jobId == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("DescribeJobExecutionSubscriptionRequest must have a non-null jobId"));
            return result;
        }
        topic = topic.replace("{jobId}", request.jobId);
        Consumer<MqttMessage> messageHandler = message -> {
            block2: {
                try {
                    String payload = new String(message.getPayload(), StandardCharsets.UTF_8);
                    RejectedError response = (RejectedError)this.gson.fromJson(payload, RejectedError.class);
                    handler.accept(response);
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block2;
                    exceptionHandler.accept(e);
                }
            }
        };
        return this.connection.subscribe(topic, qos, messageHandler);
    }

    public CompletableFuture<Integer> SubscribeToDescribeJobExecutionRejected(DescribeJobExecutionSubscriptionRequest request, QualityOfService qos, Consumer<RejectedError> handler) {
        return this.SubscribeToDescribeJobExecutionRejected(request, qos, handler, null);
    }

    public CompletableFuture<Integer> SubscribeToGetPendingJobExecutionsAccepted(GetPendingJobExecutionsSubscriptionRequest request, QualityOfService qos, Consumer<GetPendingJobExecutionsResponse> handler, Consumer<Exception> exceptionHandler) {
        String topic = "$aws/things/{thingName}/jobs/get/accepted";
        if (request.thingName == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("GetPendingJobExecutionsSubscriptionRequest must have a non-null thingName"));
            return result;
        }
        topic = topic.replace("{thingName}", request.thingName);
        Consumer<MqttMessage> messageHandler = message -> {
            block2: {
                try {
                    String payload = new String(message.getPayload(), StandardCharsets.UTF_8);
                    GetPendingJobExecutionsResponse response = (GetPendingJobExecutionsResponse)this.gson.fromJson(payload, GetPendingJobExecutionsResponse.class);
                    handler.accept(response);
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block2;
                    exceptionHandler.accept(e);
                }
            }
        };
        return this.connection.subscribe(topic, qos, messageHandler);
    }

    public CompletableFuture<Integer> SubscribeToGetPendingJobExecutionsAccepted(GetPendingJobExecutionsSubscriptionRequest request, QualityOfService qos, Consumer<GetPendingJobExecutionsResponse> handler) {
        return this.SubscribeToGetPendingJobExecutionsAccepted(request, qos, handler, null);
    }

    public CompletableFuture<Integer> SubscribeToGetPendingJobExecutionsRejected(GetPendingJobExecutionsSubscriptionRequest request, QualityOfService qos, Consumer<RejectedError> handler, Consumer<Exception> exceptionHandler) {
        String topic = "$aws/things/{thingName}/jobs/get/rejected";
        if (request.thingName == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("GetPendingJobExecutionsSubscriptionRequest must have a non-null thingName"));
            return result;
        }
        topic = topic.replace("{thingName}", request.thingName);
        Consumer<MqttMessage> messageHandler = message -> {
            block2: {
                try {
                    String payload = new String(message.getPayload(), StandardCharsets.UTF_8);
                    RejectedError response = (RejectedError)this.gson.fromJson(payload, RejectedError.class);
                    handler.accept(response);
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block2;
                    exceptionHandler.accept(e);
                }
            }
        };
        return this.connection.subscribe(topic, qos, messageHandler);
    }

    public CompletableFuture<Integer> SubscribeToGetPendingJobExecutionsRejected(GetPendingJobExecutionsSubscriptionRequest request, QualityOfService qos, Consumer<RejectedError> handler) {
        return this.SubscribeToGetPendingJobExecutionsRejected(request, qos, handler, null);
    }

    public CompletableFuture<Integer> SubscribeToJobExecutionsChangedEvents(JobExecutionsChangedSubscriptionRequest request, QualityOfService qos, Consumer<JobExecutionsChangedEvent> handler, Consumer<Exception> exceptionHandler) {
        String topic = "$aws/things/{thingName}/jobs/notify";
        if (request.thingName == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("JobExecutionsChangedSubscriptionRequest must have a non-null thingName"));
            return result;
        }
        topic = topic.replace("{thingName}", request.thingName);
        Consumer<MqttMessage> messageHandler = message -> {
            block2: {
                try {
                    String payload = new String(message.getPayload(), StandardCharsets.UTF_8);
                    JobExecutionsChangedEvent response = (JobExecutionsChangedEvent)this.gson.fromJson(payload, JobExecutionsChangedEvent.class);
                    handler.accept(response);
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block2;
                    exceptionHandler.accept(e);
                }
            }
        };
        return this.connection.subscribe(topic, qos, messageHandler);
    }

    public CompletableFuture<Integer> SubscribeToJobExecutionsChangedEvents(JobExecutionsChangedSubscriptionRequest request, QualityOfService qos, Consumer<JobExecutionsChangedEvent> handler) {
        return this.SubscribeToJobExecutionsChangedEvents(request, qos, handler, null);
    }

    public CompletableFuture<Integer> SubscribeToNextJobExecutionChangedEvents(NextJobExecutionChangedSubscriptionRequest request, QualityOfService qos, Consumer<NextJobExecutionChangedEvent> handler, Consumer<Exception> exceptionHandler) {
        String topic = "$aws/things/{thingName}/jobs/notify-next";
        if (request.thingName == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("NextJobExecutionChangedSubscriptionRequest must have a non-null thingName"));
            return result;
        }
        topic = topic.replace("{thingName}", request.thingName);
        Consumer<MqttMessage> messageHandler = message -> {
            block2: {
                try {
                    String payload = new String(message.getPayload(), StandardCharsets.UTF_8);
                    NextJobExecutionChangedEvent response = (NextJobExecutionChangedEvent)this.gson.fromJson(payload, NextJobExecutionChangedEvent.class);
                    handler.accept(response);
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block2;
                    exceptionHandler.accept(e);
                }
            }
        };
        return this.connection.subscribe(topic, qos, messageHandler);
    }

    public CompletableFuture<Integer> SubscribeToNextJobExecutionChangedEvents(NextJobExecutionChangedSubscriptionRequest request, QualityOfService qos, Consumer<NextJobExecutionChangedEvent> handler) {
        return this.SubscribeToNextJobExecutionChangedEvents(request, qos, handler, null);
    }

    public CompletableFuture<Integer> SubscribeToStartNextPendingJobExecutionAccepted(StartNextPendingJobExecutionSubscriptionRequest request, QualityOfService qos, Consumer<StartNextJobExecutionResponse> handler, Consumer<Exception> exceptionHandler) {
        String topic = "$aws/things/{thingName}/jobs/start-next/accepted";
        if (request.thingName == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("StartNextPendingJobExecutionSubscriptionRequest must have a non-null thingName"));
            return result;
        }
        topic = topic.replace("{thingName}", request.thingName);
        Consumer<MqttMessage> messageHandler = message -> {
            block2: {
                try {
                    String payload = new String(message.getPayload(), StandardCharsets.UTF_8);
                    StartNextJobExecutionResponse response = (StartNextJobExecutionResponse)this.gson.fromJson(payload, StartNextJobExecutionResponse.class);
                    handler.accept(response);
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block2;
                    exceptionHandler.accept(e);
                }
            }
        };
        return this.connection.subscribe(topic, qos, messageHandler);
    }

    public CompletableFuture<Integer> SubscribeToStartNextPendingJobExecutionAccepted(StartNextPendingJobExecutionSubscriptionRequest request, QualityOfService qos, Consumer<StartNextJobExecutionResponse> handler) {
        return this.SubscribeToStartNextPendingJobExecutionAccepted(request, qos, handler, null);
    }

    public CompletableFuture<Integer> SubscribeToStartNextPendingJobExecutionRejected(StartNextPendingJobExecutionSubscriptionRequest request, QualityOfService qos, Consumer<RejectedError> handler, Consumer<Exception> exceptionHandler) {
        String topic = "$aws/things/{thingName}/jobs/start-next/rejected";
        if (request.thingName == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("StartNextPendingJobExecutionSubscriptionRequest must have a non-null thingName"));
            return result;
        }
        topic = topic.replace("{thingName}", request.thingName);
        Consumer<MqttMessage> messageHandler = message -> {
            block2: {
                try {
                    String payload = new String(message.getPayload(), StandardCharsets.UTF_8);
                    RejectedError response = (RejectedError)this.gson.fromJson(payload, RejectedError.class);
                    handler.accept(response);
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block2;
                    exceptionHandler.accept(e);
                }
            }
        };
        return this.connection.subscribe(topic, qos, messageHandler);
    }

    public CompletableFuture<Integer> SubscribeToStartNextPendingJobExecutionRejected(StartNextPendingJobExecutionSubscriptionRequest request, QualityOfService qos, Consumer<RejectedError> handler) {
        return this.SubscribeToStartNextPendingJobExecutionRejected(request, qos, handler, null);
    }

    public CompletableFuture<Integer> SubscribeToUpdateJobExecutionAccepted(UpdateJobExecutionSubscriptionRequest request, QualityOfService qos, Consumer<UpdateJobExecutionResponse> handler, Consumer<Exception> exceptionHandler) {
        String topic = "$aws/things/{thingName}/jobs/{jobId}/update/accepted";
        if (request.thingName == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("UpdateJobExecutionSubscriptionRequest must have a non-null thingName"));
            return result;
        }
        topic = topic.replace("{thingName}", request.thingName);
        if (request.jobId == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("UpdateJobExecutionSubscriptionRequest must have a non-null jobId"));
            return result;
        }
        topic = topic.replace("{jobId}", request.jobId);
        Consumer<MqttMessage> messageHandler = message -> {
            block2: {
                try {
                    String payload = new String(message.getPayload(), StandardCharsets.UTF_8);
                    UpdateJobExecutionResponse response = (UpdateJobExecutionResponse)this.gson.fromJson(payload, UpdateJobExecutionResponse.class);
                    handler.accept(response);
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block2;
                    exceptionHandler.accept(e);
                }
            }
        };
        return this.connection.subscribe(topic, qos, messageHandler);
    }

    public CompletableFuture<Integer> SubscribeToUpdateJobExecutionAccepted(UpdateJobExecutionSubscriptionRequest request, QualityOfService qos, Consumer<UpdateJobExecutionResponse> handler) {
        return this.SubscribeToUpdateJobExecutionAccepted(request, qos, handler, null);
    }

    public CompletableFuture<Integer> SubscribeToUpdateJobExecutionRejected(UpdateJobExecutionSubscriptionRequest request, QualityOfService qos, Consumer<RejectedError> handler, Consumer<Exception> exceptionHandler) {
        String topic = "$aws/things/{thingName}/jobs/{jobId}/update/rejected";
        if (request.thingName == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("UpdateJobExecutionSubscriptionRequest must have a non-null thingName"));
            return result;
        }
        topic = topic.replace("{thingName}", request.thingName);
        if (request.jobId == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("UpdateJobExecutionSubscriptionRequest must have a non-null jobId"));
            return result;
        }
        topic = topic.replace("{jobId}", request.jobId);
        Consumer<MqttMessage> messageHandler = message -> {
            block2: {
                try {
                    String payload = new String(message.getPayload(), StandardCharsets.UTF_8);
                    RejectedError response = (RejectedError)this.gson.fromJson(payload, RejectedError.class);
                    handler.accept(response);
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block2;
                    exceptionHandler.accept(e);
                }
            }
        };
        return this.connection.subscribe(topic, qos, messageHandler);
    }

    public CompletableFuture<Integer> SubscribeToUpdateJobExecutionRejected(UpdateJobExecutionSubscriptionRequest request, QualityOfService qos, Consumer<RejectedError> handler) {
        return this.SubscribeToUpdateJobExecutionRejected(request, qos, handler, null);
    }
}

