/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 *
 * This file is generated.
 */

package software.amazon.awssdk.iot.iotjobs.model;

import software.amazon.awssdk.iot.Timestamp;
import software.amazon.awssdk.iot.iotjobs.model.JobExecutionState;
import software.amazon.awssdk.iot.iotjobs.model.RejectedErrorCode;

/**
 * Response document containing details about a failed request.
 *
 */
public class V2ErrorResponse {

    /**
     * Opaque token that can correlate this response to the original request.
     *
     */
    public String clientToken;


    /**
     * Indicates the type of error.
     *
     */
    public RejectedErrorCode code;


    /**
     * A text message that provides additional information.
     *
     */
    public String message;


    /**
     * The date and time the response was generated by AWS IoT.
     *
     */
    public Timestamp timestamp;


    /**
     * A JobExecutionState object. This field is included only when the code field has the value InvalidStateTransition or VersionMismatch.
     *
     */
    public JobExecutionState executionState;


}
