/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 *
 * This file is generated.
 */

package software.amazon.awssdk.iot.iotshadow.model;

import software.amazon.awssdk.iot.Timestamp;

/**
 * Response document containing details about a failed request.
 *
 */
public class V2ErrorResponse {

    /**
     * Opaque request-response correlation data.  Present only if a client token was used in the request.
     *
     */
    public String clientToken;


    /**
     * An HTTP response code that indicates the type of error.
     *
     */
    public Integer code;


    /**
     * A text message that provides additional information.
     *
     */
    public String message;


    /**
     * The date and time the response was generated by AWS IoT. This property is not present in all error response documents.
     *
     */
    public Timestamp timestamp;


}
