/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.aws.greengrass.model.RequestStatus;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class RestartComponentResponse
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#RestartComponentResponse";
    public static final RestartComponentResponse VOID = new RestartComponentResponse(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<String> restartStatus = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> message = Optional.empty();

    public RequestStatus getRestartStatus() {
        if (this.restartStatus.isPresent()) {
            return RequestStatus.get(this.restartStatus.get());
        }
        return null;
    }

    public String getRestartStatusAsString() {
        if (this.restartStatus.isPresent()) {
            return this.restartStatus.get();
        }
        return null;
    }

    public void setRestartStatus(String restartStatus) {
        this.restartStatus = Optional.ofNullable(restartStatus);
    }

    public RestartComponentResponse withRestartStatus(String restartStatus) {
        this.setRestartStatus(restartStatus);
        return this;
    }

    public void setRestartStatus(RequestStatus restartStatus) {
        this.restartStatus = Optional.ofNullable(restartStatus.getValue());
    }

    public RestartComponentResponse withRestartStatus(RequestStatus restartStatus) {
        this.setRestartStatus(restartStatus);
        return this;
    }

    public String getMessage() {
        if (this.message.isPresent()) {
            return this.message.get();
        }
        return null;
    }

    public void setMessage(String message) {
        this.message = Optional.ofNullable(message);
    }

    public RestartComponentResponse withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof RestartComponentResponse)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        RestartComponentResponse other = (RestartComponentResponse)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.restartStatus.equals(other.restartStatus);
        isEquals = isEquals && this.message.equals(other.message);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.restartStatus, this.message);
    }
}

