/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.aws.greengrass.model.GreengrassCoreIPCError;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class ServiceError
extends GreengrassCoreIPCError
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#ServiceError";
    public static final ServiceError VOID = new ServiceError(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<String> message;
    @Expose(serialize=true, deserialize=true)
    private Optional<Map<String, Object>> context;

    public ServiceError(String errorMessage) {
        super("ServiceError", errorMessage);
        this.message = Optional.ofNullable(errorMessage);
        this.context = Optional.empty();
    }

    public ServiceError() {
        super("ServiceError", "");
        this.message = Optional.empty();
        this.context = Optional.empty();
    }

    @Override
    public String getErrorTypeString() {
        return "server";
    }

    @Override
    public String getMessage() {
        if (this.message.isPresent()) {
            return this.message.get();
        }
        return null;
    }

    public void setMessage(String message) {
        this.message = Optional.ofNullable(message);
    }

    public ServiceError withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public Map<String, Object> getContext() {
        if (this.context.isPresent()) {
            return this.context.get();
        }
        return null;
    }

    public void setContext(Map<String, Object> context) {
        this.context = Optional.ofNullable(context);
    }

    public ServiceError withContext(Map<String, Object> context) {
        this.setContext(context);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof ServiceError)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        ServiceError other = (ServiceError)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.message.equals(other.message);
        isEquals = isEquals && this.context.equals(other.context);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.message, this.context);
    }
}

