/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.aws.greengrass.model;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.aws.greengrass.model.QOS;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamJsonMessage;

public class SubscribeToIoTCoreRequest
implements EventStreamJsonMessage {
    public static final String APPLICATION_MODEL_TYPE = "aws.greengrass#SubscribeToIoTCoreRequest";
    public static final SubscribeToIoTCoreRequest VOID = new SubscribeToIoTCoreRequest(){

        @Override
        public boolean isVoid() {
            return true;
        }
    };
    @Expose(serialize=true, deserialize=true)
    private Optional<String> topicName = Optional.empty();
    @Expose(serialize=true, deserialize=true)
    private Optional<String> qos = Optional.empty();

    public String getTopicName() {
        if (this.topicName.isPresent()) {
            return this.topicName.get();
        }
        return null;
    }

    public void setTopicName(String topicName) {
        this.topicName = Optional.ofNullable(topicName);
    }

    public SubscribeToIoTCoreRequest withTopicName(String topicName) {
        this.setTopicName(topicName);
        return this;
    }

    public QOS getQos() {
        if (this.qos.isPresent()) {
            return QOS.get(this.qos.get());
        }
        return null;
    }

    public String getQosAsString() {
        if (this.qos.isPresent()) {
            return this.qos.get();
        }
        return null;
    }

    public void setQos(String qos) {
        this.qos = Optional.ofNullable(qos);
    }

    public SubscribeToIoTCoreRequest withQos(String qos) {
        this.setQos(qos);
        return this;
    }

    public void setQos(QOS qos) {
        this.qos = Optional.ofNullable(qos.getValue());
    }

    public SubscribeToIoTCoreRequest withQos(QOS qos) {
        this.setQos(qos);
        return this;
    }

    @Override
    public String getApplicationModelType() {
        return APPLICATION_MODEL_TYPE;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof SubscribeToIoTCoreRequest)) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        SubscribeToIoTCoreRequest other = (SubscribeToIoTCoreRequest)rhs;
        boolean isEquals = true;
        isEquals = isEquals && this.topicName.equals(other.topicName);
        isEquals = isEquals && this.qos.equals(other.qos);
        return isEquals;
    }

    public int hashCode() {
        return Objects.hash(this.topicName, this.qos);
    }
}

