/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.eventstreamrpc;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.eventstream.ClientConnection;
import software.amazon.awssdk.crt.eventstream.ClientConnectionContinuation;
import software.amazon.awssdk.crt.eventstream.ClientConnectionContinuationHandler;
import software.amazon.awssdk.crt.eventstream.ClientConnectionHandler;
import software.amazon.awssdk.crt.eventstream.Header;
import software.amazon.awssdk.crt.eventstream.MessageFlags;
import software.amazon.awssdk.crt.eventstream.MessageType;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.ClientTlsContext;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.eventstreamrpc.EventStreamClosedException;
import software.amazon.awssdk.eventstreamrpc.EventStreamRPCConnectionConfig;
import software.amazon.awssdk.eventstreamrpc.MessageAmendInfo;
import software.amazon.awssdk.eventstreamrpc.Version;
import software.amazon.awssdk.eventstreamrpc.model.AccessDeniedException;
import software.amazon.awssdk.eventstreamrpc.model.EventStreamError;

public class EventStreamRPCConnection
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(EventStreamRPCConnection.class.getName());
    private final EventStreamRPCConnectionConfig config;
    protected ConnectionState connectionState;

    public EventStreamRPCConnection(EventStreamRPCConnectionConfig config) {
        this.config = config;
        this.connectionState = new ConnectionState(ConnectionState.Phase.DISCONNECTED, null);
    }

    protected String getVersionString() {
        return Version.getInstance().getVersionString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> connect(final LifecycleHandler lifecycleHandler) {
        ConnectionState connectionState = this.connectionState;
        synchronized (connectionState) {
            if (this.connectionState.connectionPhase != ConnectionState.Phase.DISCONNECTED) {
                throw new IllegalStateException("Connection is already established");
            }
            this.connectionState.connectionPhase = ConnectionState.Phase.CONNECTING_SOCKET;
            this.connectionState.onConnectCalled = false;
        }
        final CompletableFuture<Void> initialConnectFuture = new CompletableFuture<Void>();
        ClientConnection.connect((String)this.config.getHost(), (int)this.config.getPort(), (SocketOptions)this.config.getSocketOptions(), (ClientTlsContext)this.config.getTlsContext(), (ClientBootstrap)this.config.getClientBootstrap(), (ClientConnectionHandler)new ClientConnectionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onConnectionSetup(ClientConnection clientConnection, int errorCode) {
                LOGGER.info(String.format("Socket connection %s:%d to server result [%s]", EventStreamRPCConnection.this.config.getHost(), EventStreamRPCConnection.this.config.getPort(), CRT.awsErrorName((int)errorCode)));
                ConnectionState connectionState = EventStreamRPCConnection.this.connectionState;
                synchronized (connectionState) {
                    EventStreamRPCConnection.this.connectionState.connection = clientConnection;
                    if (0 != errorCode) {
                        EventStreamRPCConnection.this.connectionState.connectionPhase = ConnectionState.Phase.DISCONNECTED;
                        initialConnectFuture.completeExceptionally((Throwable)new CrtRuntimeException(errorCode, CRT.awsErrorName((int)errorCode)));
                    } else if (EventStreamRPCConnection.this.connectionState.connectionPhase == ConnectionState.Phase.CLOSING) {
                        EventStreamRPCConnection.this.connectionState.closeReason = new EventStreamClosedException("Event stream closed by client");
                        EventStreamRPCConnection.this.disconnect();
                    } else {
                        EventStreamRPCConnection.this.connectionState.connectionPhase = ConnectionState.Phase.WAITING_CONNACK;
                        EventStreamRPCConnection.this.config.getConnectMessageAmender().get().whenComplete((messageAmendInfo, ex) -> {
                            ConnectionState connectionState = EventStreamRPCConnection.this.connectionState;
                            synchronized (connectionState) {
                                if (clientConnection != EventStreamRPCConnection.this.connectionState.connection) {
                                    LOGGER.warning("MessageAmender completed with different connection than initial");
                                    return;
                                }
                                if (EventStreamRPCConnection.this.connectionState.connectionPhase == ConnectionState.Phase.CLOSING) {
                                    EventStreamRPCConnection.this.connectionState.closeReason = new EventStreamClosedException("Event stream closed by client");
                                } else {
                                    try {
                                        ArrayList<Header> headers = new ArrayList<Header>(messageAmendInfo.getHeaders().size() + 1);
                                        headers.add(Header.createHeader((String)":version", (String)EventStreamRPCConnection.this.getVersionString()));
                                        headers.addAll(messageAmendInfo.getHeaders().stream().filter(header -> !header.getName().equals(":version")).collect(Collectors.toList()));
                                        LOGGER.fine("Waiting for connect ack message back from event stream RPC server");
                                        clientConnection.sendProtocolMessage(headers, messageAmendInfo.getPayload(), MessageType.Connect, 0);
                                    }
                                    catch (Exception e) {
                                        EventStreamRPCConnection.this.connectionState.connectionPhase = ConnectionState.Phase.CLOSING;
                                        EventStreamRPCConnection.this.connectionState.closeReason = e;
                                        EventStreamRPCConnection.this.disconnect();
                                    }
                                }
                            }
                        });
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onProtocolMessage(List<Header> headers, byte[] payload, MessageType messageType, int messageFlags) {
                if (MessageType.ConnectAck.equals((Object)messageType)) {
                    ConnectionState connectionState = EventStreamRPCConnection.this.connectionState;
                    synchronized (connectionState) {
                        if ((messageFlags & MessageFlags.ConnectionAccepted.getByteValue()) != 0) {
                            EventStreamRPCConnection.this.connectionState.connectionPhase = ConnectionState.Phase.CONNECTED;
                            LOGGER.info("Connection established with event stream RPC server");
                            if (!initialConnectFuture.isDone()) {
                                initialConnectFuture.complete(null);
                            }
                            EventStreamRPCConnection.this.connectionState.onConnectCalled = true;
                            EventStreamRPCConnection.this.doOnConnect(lifecycleHandler);
                        } else {
                            LOGGER.warning("AccessDenied to event stream RPC server");
                            EventStreamRPCConnection.this.connectionState.connectionPhase = ConnectionState.Phase.CLOSING;
                            EventStreamRPCConnection.this.connectionState.connection.closeConnection(0);
                            AccessDeniedException ade = new AccessDeniedException("Connection access denied to event stream RPC server");
                            if (!initialConnectFuture.isDone()) {
                                initialConnectFuture.completeExceptionally(ade);
                            }
                            EventStreamRPCConnection.this.doOnError(lifecycleHandler, ade);
                        }
                    }
                } else if (MessageType.PingResponse.equals((Object)messageType)) {
                    LOGGER.finer("Ping response received");
                } else if (MessageType.Ping.equals((Object)messageType)) {
                    EventStreamRPCConnection.this.sendPingResponse(Optional.of(new MessageAmendInfo(headers.stream().filter(header -> !header.getName().startsWith(":")).collect(Collectors.toList()), payload))).whenComplete((res, ex) -> LOGGER.finer("Ping response sent"));
                } else if (MessageType.Connect.equals((Object)messageType)) {
                    LOGGER.severe("Erroneous connect message type received by client. Closing");
                    EventStreamRPCConnection.this.disconnect();
                } else if (MessageType.ProtocolError.equals((Object)messageType) || MessageType.ServerError.equals((Object)messageType)) {
                    LOGGER.severe("Received " + messageType.name() + ": " + CRT.awsErrorName((int)CRT.awsLastError()));
                    EventStreamRPCConnection.this.connectionState.closeReason = EventStreamError.create(headers, payload, messageType);
                    EventStreamRPCConnection.this.doOnError(lifecycleHandler, EventStreamRPCConnection.this.connectionState.closeReason);
                    EventStreamRPCConnection.this.disconnect();
                } else {
                    LOGGER.severe("Unprocessed message type: " + messageType.name());
                    EventStreamRPCConnection.this.doOnError(lifecycleHandler, new EventStreamError("Unprocessed message type: " + messageType.name()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onConnectionClosed(int errorCode) {
                boolean callOnDisconnect;
                Throwable closeReason;
                LOGGER.finer("Socket connection closed: " + CRT.awsErrorName((int)errorCode));
                ConnectionState connectionState = EventStreamRPCConnection.this.connectionState;
                synchronized (connectionState) {
                    if (EventStreamRPCConnection.this.connectionState.connection != null) {
                        EventStreamRPCConnection.this.connectionState.connection.close();
                        EventStreamRPCConnection.this.connectionState.connection = null;
                    }
                    EventStreamRPCConnection.this.connectionState.connectionPhase = ConnectionState.Phase.DISCONNECTED;
                    closeReason = EventStreamRPCConnection.this.connectionState.closeReason;
                    EventStreamRPCConnection.this.connectionState.closeReason = null;
                    callOnDisconnect = EventStreamRPCConnection.this.connectionState.onConnectCalled;
                    EventStreamRPCConnection.this.connectionState.onConnectCalled = false;
                }
                if (!initialConnectFuture.isDone()) {
                    if (closeReason != null) {
                        initialConnectFuture.completeExceptionally(closeReason);
                    } else {
                        initialConnectFuture.complete(null);
                    }
                }
                if (callOnDisconnect) {
                    EventStreamRPCConnection.this.doOnDisconnect(lifecycleHandler, errorCode);
                }
            }
        });
        return initialConnectFuture;
    }

    public ClientConnectionContinuation newStream(ClientConnectionContinuationHandler continuationHandler) {
        ConnectionState connectionState = this.connectionState;
        synchronized (connectionState) {
            if (this.connectionState.connectionPhase == ConnectionState.Phase.CONNECTED) {
                return this.connectionState.connection.newStream(continuationHandler);
            }
            throw new EventStreamClosedException("EventStream connection is not open!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        ConnectionState connectionState = this.connectionState;
        synchronized (connectionState) {
            if (this.connectionState.connectionPhase != ConnectionState.Phase.CLOSING && this.connectionState.connectionPhase != ConnectionState.Phase.DISCONNECTED) {
                this.connectionState.connectionPhase = ConnectionState.Phase.CLOSING;
            }
            if (this.connectionState.connection != null) {
                this.connectionState.connection.closeConnection(0);
            }
            if (this.connectionState.closeReason == null) {
                this.connectionState.closeReason = new EventStreamClosedException("Event stream closed by client");
            }
        }
    }

    private void doOnConnect(LifecycleHandler lifecycleHandler) {
        try {
            lifecycleHandler.onConnect();
        }
        catch (Exception ex) {
            LOGGER.warning(String.format("LifecycleHandler::onConnect() threw %s : %s", ex.getClass().getCanonicalName(), ex.getMessage()));
            this.doOnError(lifecycleHandler, ex);
        }
    }

    private void doOnError(LifecycleHandler lifecycleHandler, Throwable t) {
        try {
            if (lifecycleHandler.onError(t)) {
                LOGGER.fine("Closing connection due to LifecycleHandler::onError() returning true");
                this.disconnect();
            }
        }
        catch (Exception ex) {
            LOGGER.warning(String.format("Closing connection due to LifecycleHandler::onError() throwing %s : %s", ex.getClass().getCanonicalName(), ex.getMessage()));
            this.disconnect();
        }
    }

    private void doOnDisconnect(LifecycleHandler lifecycleHandler, int errorCode) {
        try {
            lifecycleHandler.onDisconnect(errorCode);
        }
        catch (Exception ex) {
            LOGGER.warning(String.format("LifecycleHandler::onDisconnect(" + CRT.awsErrorName((int)errorCode) + ") threw %s : %s", ex.getClass().getCanonicalName(), ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> sendPing(Optional<MessageAmendInfo> pingData) {
        ConnectionState connectionState = this.connectionState;
        synchronized (connectionState) {
            if (this.connectionState.connectionPhase != ConnectionState.Phase.CONNECTED) {
                throw new EventStreamClosedException("EventStream connection not established");
            }
            ClientConnection connection = this.connectionState.connection;
            if (pingData.isPresent()) {
                return connection.sendProtocolMessage(pingData.get().getHeaders(), pingData.get().getPayload(), MessageType.Ping, 0);
            }
            return connection.sendProtocolMessage(null, null, MessageType.Ping, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> sendPingResponse(Optional<MessageAmendInfo> pingResponseData) {
        ConnectionState connectionState = this.connectionState;
        synchronized (connectionState) {
            if (this.connectionState.connectionPhase != ConnectionState.Phase.CONNECTED) {
                throw new EventStreamClosedException("EventStream connection not established");
            }
            ClientConnection connection = this.connectionState.connection;
            if (pingResponseData.isPresent()) {
                return connection.sendProtocolMessage(pingResponseData.get().getHeaders(), pingResponseData.get().getPayload(), MessageType.Ping, 0);
            }
            return connection.sendProtocolMessage(null, null, MessageType.PingResponse, 0);
        }
    }

    @Override
    public void close() {
        this.disconnect();
    }

    public static interface LifecycleHandler {
        public void onConnect();

        public void onDisconnect(int var1);

        public boolean onError(Throwable var1);

        default public void onPing(List<Header> headers, byte[] payload) {
        }
    }

    protected static class ConnectionState {
        Phase connectionPhase;
        ClientConnection connection;
        Throwable closeReason;
        boolean onConnectCalled;

        protected ConnectionState(Phase phase, ClientConnection connection) {
            this.connectionPhase = phase;
            this.connection = connection;
            this.closeReason = null;
            this.onConnectCalled = false;
        }

        static enum Phase {
            DISCONNECTED,
            CONNECTING_SOCKET,
            WAITING_CONNACK,
            CONNECTED,
            CLOSING;

        }
    }
}

