/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.eventstreamrpc;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final String PATTERN_REGEX_STRING = "^(\\d+)\\.(\\d+)\\.(\\d+)$";
    public static final Pattern PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)$");
    public static final int MAJOR = 0;
    public static final int MINOR = 1;
    public static final int PATCH = 0;
    private static final Version INSTANCE = new Version(0, 1, 0);
    private final int major;
    private final int minor;
    private final int patch;

    public static Version getInstance() {
        return INSTANCE;
    }

    private Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public String getVersionString() {
        return String.format("%d.%d.%d", 0, 1, 0);
    }

    public String toString() {
        return this.getVersionString();
    }

    public static Version fromString(String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException("Cannot extract version from null string");
        }
        Matcher matcher = PATTERN.matcher(versionString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Version string does not match regex: ^(\\d+)\\.(\\d+)\\.(\\d+)$");
        }
        return new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (rhs instanceof Version) {
            return this.compareTo((Version)rhs) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Version rhs) {
        if (rhs == null) {
            throw new IllegalArgumentException("Cannot compare to null version!");
        }
        if (this.major - rhs.major == 0) {
            if (this.minor - rhs.minor == 0) {
                return this.patch - rhs.patch;
            }
            return this.minor - rhs.minor;
        }
        return this.major - rhs.major;
    }
}

