/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.eventstreamrpc.model;

import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.List;
import software.amazon.awssdk.crt.eventstream.Header;
import software.amazon.awssdk.crt.eventstream.MessageType;
import software.amazon.awssdk.eventstreamrpc.EventStreamRPCServiceModel;

public class EventStreamError
extends RuntimeException {
    private final List<Header> headers;
    private final MessageType messageType;

    public static EventStreamError create(List<Header> headers, byte[] payload, MessageType messageType) {
        try {
            HashMap map = (HashMap)EventStreamRPCServiceModel.getStaticGson().fromJson(new String(payload), HashMap.class);
            String message = map.getOrDefault("message", "no message").toString();
            return new EventStreamError(String.format("%s: %s", messageType.name(), message), headers, messageType);
        }
        catch (JsonSyntaxException jse) {
            return new EventStreamError(String.format("%s: Failed to deserialize error message as JSON(%s)", messageType.name(), jse.toString()), headers, messageType);
        }
    }

    public EventStreamError(String message) {
        super(message);
        this.messageType = null;
        this.headers = null;
    }

    public EventStreamError(String message, List<Header> headers, MessageType messageType) {
        super(message);
        this.messageType = messageType;
        this.headers = headers;
    }

    public List<Header> getMessageHeaders() {
        return this.headers;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }
}

