/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.iot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class EnumSerializer<E>
implements JsonSerializer<E>,
JsonDeserializer<E> {
    private Method fromString;

    public JsonElement serialize(E enumValue, Type typeOfEnum, JsonSerializationContext context) {
        return new JsonPrimitive(enumValue.toString());
    }

    public E deserialize(JsonElement json, Type typeOfEnum, JsonDeserializationContext context) throws JsonParseException {
        if (this.fromString == null) {
            Class c = (Class)typeOfEnum;
            for (Method m : c.getDeclaredMethods()) {
                if (m.getName() != "fromString") continue;
                this.fromString = m;
                this.fromString.setAccessible(true);
                break;
            }
        }
        try {
            Object value = this.fromString.invoke(null, json.getAsJsonPrimitive().getAsString());
            return (E)value;
        }
        catch (Exception ex) {
            Class c = (Class)typeOfEnum;
            return (E)c.getEnumConstants()[0];
        }
    }
}

