/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.iot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;

public class Timestamp
extends Date {
    public Timestamp(Date date) {
        super(date.getTime());
    }

    public static class Deserializer
    implements JsonDeserializer<Timestamp> {
        public Timestamp deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new Timestamp(new Date(json.getAsJsonPrimitive().getAsLong() * 1000L));
        }
    }

    public static class Serializer
    implements JsonSerializer<Timestamp> {
        public JsonElement serialize(Timestamp src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)(src.getTime() / 1000L));
        }
    }
}

