/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.iot.iotidentity;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.crt.mqtt.MqttClientConnection;
import software.amazon.awssdk.crt.mqtt.MqttException;
import software.amazon.awssdk.crt.mqtt.MqttMessage;
import software.amazon.awssdk.crt.mqtt.QualityOfService;
import software.amazon.awssdk.iot.Timestamp;
import software.amazon.awssdk.iot.iotidentity.model.CreateCertificateFromCsrRequest;
import software.amazon.awssdk.iot.iotidentity.model.CreateCertificateFromCsrResponse;
import software.amazon.awssdk.iot.iotidentity.model.CreateCertificateFromCsrSubscriptionRequest;
import software.amazon.awssdk.iot.iotidentity.model.CreateKeysAndCertificateRequest;
import software.amazon.awssdk.iot.iotidentity.model.CreateKeysAndCertificateResponse;
import software.amazon.awssdk.iot.iotidentity.model.CreateKeysAndCertificateSubscriptionRequest;
import software.amazon.awssdk.iot.iotidentity.model.ErrorResponse;
import software.amazon.awssdk.iot.iotidentity.model.RegisterThingRequest;
import software.amazon.awssdk.iot.iotidentity.model.RegisterThingResponse;
import software.amazon.awssdk.iot.iotidentity.model.RegisterThingSubscriptionRequest;

public class IotIdentityClient {
    private MqttClientConnection connection = null;
    private final Gson gson = this.getGson();

    public IotIdentityClient(MqttClientConnection connection) {
        this.connection = connection;
    }

    private Gson getGson() {
        GsonBuilder gson = new GsonBuilder();
        gson.disableHtmlEscaping();
        gson.registerTypeAdapter(Timestamp.class, (Object)new Timestamp.Serializer());
        gson.registerTypeAdapter(Timestamp.class, (Object)new Timestamp.Deserializer());
        this.addTypeAdapters(gson);
        return gson.create();
    }

    private void addTypeAdapters(GsonBuilder gson) {
    }

    public CompletableFuture<Integer> PublishCreateCertificateFromCsr(CreateCertificateFromCsrRequest request, QualityOfService qos) {
        String topic = "$aws/certificates/create-from-csr/json";
        String payloadJson = this.gson.toJson((Object)request);
        MqttMessage message = new MqttMessage(topic, payloadJson.getBytes(StandardCharsets.UTF_8));
        return this.connection.publish(message, qos, false);
    }

    public CompletableFuture<Integer> PublishCreateKeysAndCertificate(CreateKeysAndCertificateRequest request, QualityOfService qos) {
        String topic = "$aws/certificates/create/json";
        String payloadJson = this.gson.toJson((Object)request);
        MqttMessage message = new MqttMessage(topic, payloadJson.getBytes(StandardCharsets.UTF_8));
        return this.connection.publish(message, qos, false);
    }

    public CompletableFuture<Integer> PublishRegisterThing(RegisterThingRequest request, QualityOfService qos) {
        String topic = "$aws/provisioning-templates/{templateName}/provision/json";
        if (request.templateName == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("RegisterThingRequest must have a non-null templateName"));
            return result;
        }
        topic = topic.replace("{templateName}", request.templateName);
        String payloadJson = this.gson.toJson((Object)request);
        MqttMessage message = new MqttMessage(topic, payloadJson.getBytes(StandardCharsets.UTF_8));
        return this.connection.publish(message, qos, false);
    }

    public CompletableFuture<Integer> SubscribeToCreateCertificateFromCsrAccepted(CreateCertificateFromCsrSubscriptionRequest request, QualityOfService qos, Consumer<CreateCertificateFromCsrResponse> handler, Consumer<Exception> exceptionHandler) {
        String topic = "$aws/certificates/create-from-csr/json/accepted";
        Consumer<MqttMessage> messageHandler = message -> {
            block2: {
                try {
                    String payload = new String(message.getPayload(), StandardCharsets.UTF_8);
                    CreateCertificateFromCsrResponse response = (CreateCertificateFromCsrResponse)this.gson.fromJson(payload, CreateCertificateFromCsrResponse.class);
                    handler.accept(response);
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block2;
                    exceptionHandler.accept(e);
                }
            }
        };
        return this.connection.subscribe(topic, qos, messageHandler);
    }

    public CompletableFuture<Integer> SubscribeToCreateCertificateFromCsrAccepted(CreateCertificateFromCsrSubscriptionRequest request, QualityOfService qos, Consumer<CreateCertificateFromCsrResponse> handler) {
        return this.SubscribeToCreateCertificateFromCsrAccepted(request, qos, handler, null);
    }

    public CompletableFuture<Integer> SubscribeToCreateCertificateFromCsrRejected(CreateCertificateFromCsrSubscriptionRequest request, QualityOfService qos, Consumer<ErrorResponse> handler, Consumer<Exception> exceptionHandler) {
        String topic = "$aws/certificates/create-from-csr/json/rejected";
        Consumer<MqttMessage> messageHandler = message -> {
            block2: {
                try {
                    String payload = new String(message.getPayload(), StandardCharsets.UTF_8);
                    ErrorResponse response = (ErrorResponse)this.gson.fromJson(payload, ErrorResponse.class);
                    handler.accept(response);
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block2;
                    exceptionHandler.accept(e);
                }
            }
        };
        return this.connection.subscribe(topic, qos, messageHandler);
    }

    public CompletableFuture<Integer> SubscribeToCreateCertificateFromCsrRejected(CreateCertificateFromCsrSubscriptionRequest request, QualityOfService qos, Consumer<ErrorResponse> handler) {
        return this.SubscribeToCreateCertificateFromCsrRejected(request, qos, handler, null);
    }

    public CompletableFuture<Integer> SubscribeToCreateKeysAndCertificateAccepted(CreateKeysAndCertificateSubscriptionRequest request, QualityOfService qos, Consumer<CreateKeysAndCertificateResponse> handler, Consumer<Exception> exceptionHandler) {
        String topic = "$aws/certificates/create/json/accepted";
        Consumer<MqttMessage> messageHandler = message -> {
            block2: {
                try {
                    String payload = new String(message.getPayload(), StandardCharsets.UTF_8);
                    CreateKeysAndCertificateResponse response = (CreateKeysAndCertificateResponse)this.gson.fromJson(payload, CreateKeysAndCertificateResponse.class);
                    handler.accept(response);
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block2;
                    exceptionHandler.accept(e);
                }
            }
        };
        return this.connection.subscribe(topic, qos, messageHandler);
    }

    public CompletableFuture<Integer> SubscribeToCreateKeysAndCertificateAccepted(CreateKeysAndCertificateSubscriptionRequest request, QualityOfService qos, Consumer<CreateKeysAndCertificateResponse> handler) {
        return this.SubscribeToCreateKeysAndCertificateAccepted(request, qos, handler, null);
    }

    public CompletableFuture<Integer> SubscribeToCreateKeysAndCertificateRejected(CreateKeysAndCertificateSubscriptionRequest request, QualityOfService qos, Consumer<ErrorResponse> handler, Consumer<Exception> exceptionHandler) {
        String topic = "$aws/certificates/create/json/rejected";
        Consumer<MqttMessage> messageHandler = message -> {
            block2: {
                try {
                    String payload = new String(message.getPayload(), StandardCharsets.UTF_8);
                    ErrorResponse response = (ErrorResponse)this.gson.fromJson(payload, ErrorResponse.class);
                    handler.accept(response);
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block2;
                    exceptionHandler.accept(e);
                }
            }
        };
        return this.connection.subscribe(topic, qos, messageHandler);
    }

    public CompletableFuture<Integer> SubscribeToCreateKeysAndCertificateRejected(CreateKeysAndCertificateSubscriptionRequest request, QualityOfService qos, Consumer<ErrorResponse> handler) {
        return this.SubscribeToCreateKeysAndCertificateRejected(request, qos, handler, null);
    }

    public CompletableFuture<Integer> SubscribeToRegisterThingAccepted(RegisterThingSubscriptionRequest request, QualityOfService qos, Consumer<RegisterThingResponse> handler, Consumer<Exception> exceptionHandler) {
        String topic = "$aws/provisioning-templates/{templateName}/provision/json/accepted";
        if (request.templateName == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("RegisterThingSubscriptionRequest must have a non-null templateName"));
            return result;
        }
        topic = topic.replace("{templateName}", request.templateName);
        Consumer<MqttMessage> messageHandler = message -> {
            block2: {
                try {
                    String payload = new String(message.getPayload(), StandardCharsets.UTF_8);
                    RegisterThingResponse response = (RegisterThingResponse)this.gson.fromJson(payload, RegisterThingResponse.class);
                    handler.accept(response);
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block2;
                    exceptionHandler.accept(e);
                }
            }
        };
        return this.connection.subscribe(topic, qos, messageHandler);
    }

    public CompletableFuture<Integer> SubscribeToRegisterThingAccepted(RegisterThingSubscriptionRequest request, QualityOfService qos, Consumer<RegisterThingResponse> handler) {
        return this.SubscribeToRegisterThingAccepted(request, qos, handler, null);
    }

    public CompletableFuture<Integer> SubscribeToRegisterThingRejected(RegisterThingSubscriptionRequest request, QualityOfService qos, Consumer<ErrorResponse> handler, Consumer<Exception> exceptionHandler) {
        String topic = "$aws/provisioning-templates/{templateName}/provision/json/rejected";
        if (request.templateName == null) {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            result.completeExceptionally((Throwable)new MqttException("RegisterThingSubscriptionRequest must have a non-null templateName"));
            return result;
        }
        topic = topic.replace("{templateName}", request.templateName);
        Consumer<MqttMessage> messageHandler = message -> {
            block2: {
                try {
                    String payload = new String(message.getPayload(), StandardCharsets.UTF_8);
                    ErrorResponse response = (ErrorResponse)this.gson.fromJson(payload, ErrorResponse.class);
                    handler.accept(response);
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block2;
                    exceptionHandler.accept(e);
                }
            }
        };
        return this.connection.subscribe(topic, qos, messageHandler);
    }

    public CompletableFuture<Integer> SubscribeToRegisterThingRejected(RegisterThingSubscriptionRequest request, QualityOfService qos, Consumer<ErrorResponse> handler) {
        return this.SubscribeToRegisterThingRejected(request, qos, handler, null);
    }
}

