/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.iot.iotidentity;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.iot.MqttRequestResponse;
import software.amazon.awssdk.crt.iot.MqttRequestResponseClient;
import software.amazon.awssdk.crt.iot.MqttRequestResponseClientOptions;
import software.amazon.awssdk.crt.iot.RequestResponseOperation;
import software.amazon.awssdk.crt.iot.ResponsePath;
import software.amazon.awssdk.crt.mqtt.MqttClientConnection;
import software.amazon.awssdk.crt.mqtt5.Mqtt5Client;
import software.amazon.awssdk.iot.Timestamp;
import software.amazon.awssdk.iot.V2ClientFuture;
import software.amazon.awssdk.iot.iotidentity.model.CreateCertificateFromCsrRequest;
import software.amazon.awssdk.iot.iotidentity.model.CreateCertificateFromCsrResponse;
import software.amazon.awssdk.iot.iotidentity.model.CreateKeysAndCertificateRequest;
import software.amazon.awssdk.iot.iotidentity.model.CreateKeysAndCertificateResponse;
import software.amazon.awssdk.iot.iotidentity.model.RegisterThingRequest;
import software.amazon.awssdk.iot.iotidentity.model.RegisterThingResponse;
import software.amazon.awssdk.iot.iotidentity.model.V2ErrorResponse;
import software.amazon.awssdk.iot.iotidentity.model.V2ErrorResponseException;

public class IotIdentityV2Client
implements AutoCloseable {
    private MqttRequestResponseClient rrClient;
    private final Gson gson;

    private Gson createGson() {
        GsonBuilder gson = new GsonBuilder();
        gson.disableHtmlEscaping();
        gson.registerTypeAdapter(Timestamp.class, (Object)new Timestamp.Serializer());
        gson.registerTypeAdapter(Timestamp.class, (Object)new Timestamp.Deserializer());
        this.addTypeAdapters(gson);
        return gson.create();
    }

    private void addTypeAdapters(GsonBuilder gson) {
    }

    private IotIdentityV2Client(MqttRequestResponseClient rrClient) {
        this.rrClient = rrClient;
        this.gson = this.createGson();
    }

    public static IotIdentityV2Client newFromMqtt5(Mqtt5Client protocolClient, MqttRequestResponseClientOptions options) {
        MqttRequestResponseClient rrClient = new MqttRequestResponseClient(protocolClient, options);
        return new IotIdentityV2Client(rrClient);
    }

    public static IotIdentityV2Client newFromMqtt311(MqttClientConnection protocolClient, MqttRequestResponseClientOptions options) {
        MqttRequestResponseClient rrClient = new MqttRequestResponseClient(protocolClient, options);
        return new IotIdentityV2Client(rrClient);
    }

    @Override
    public void close() {
        this.rrClient.decRef();
        this.rrClient = null;
    }

    public CompletableFuture<CreateCertificateFromCsrResponse> createCertificateFromCsr(CreateCertificateFromCsrRequest request) {
        V2ClientFuture<CreateCertificateFromCsrResponse> responseFuture = new V2ClientFuture<CreateCertificateFromCsrResponse>();
        try {
            RequestResponseOperation.RequestResponseOperationBuilder builder = RequestResponseOperation.builder();
            String publishTopic = "$aws/certificates/create-from-csr/json";
            builder.withPublishTopic(publishTopic);
            String payloadJson = this.gson.toJson((Object)request);
            builder.withPayload(payloadJson.getBytes(StandardCharsets.UTF_8));
            String subscription0 = "$aws/certificates/create-from-csr/json/accepted";
            builder.withSubscription(subscription0);
            String subscription1 = "$aws/certificates/create-from-csr/json/rejected";
            builder.withSubscription(subscription1);
            ResponsePath.ResponsePathBuilder pathBuilder1 = ResponsePath.builder();
            String responseTopic1 = publishTopic + "/accepted";
            pathBuilder1.withResponseTopic(publishTopic + "/accepted");
            builder.withResponsePath(pathBuilder1.build());
            ResponsePath.ResponsePathBuilder pathBuilder2 = ResponsePath.builder();
            String responseTopic2 = publishTopic + "/rejected";
            pathBuilder2.withResponseTopic(publishTopic + "/rejected");
            builder.withResponsePath(pathBuilder2.build());
            this.submitOperation(responseFuture, builder.build(), responseTopic1, CreateCertificateFromCsrResponse.class, responseTopic2, V2ErrorResponse.class, IotIdentityV2Client::createV2ErrorResponseException);
        }
        catch (Exception e) {
            responseFuture.completeExceptionally(IotIdentityV2Client.createV2ErrorResponseException(e.getMessage(), null));
        }
        return responseFuture;
    }

    public CompletableFuture<CreateKeysAndCertificateResponse> createKeysAndCertificate(CreateKeysAndCertificateRequest request) {
        V2ClientFuture<CreateKeysAndCertificateResponse> responseFuture = new V2ClientFuture<CreateKeysAndCertificateResponse>();
        try {
            RequestResponseOperation.RequestResponseOperationBuilder builder = RequestResponseOperation.builder();
            String publishTopic = "$aws/certificates/create/json";
            builder.withPublishTopic(publishTopic);
            String payloadJson = this.gson.toJson((Object)request);
            builder.withPayload(payloadJson.getBytes(StandardCharsets.UTF_8));
            String subscription0 = "$aws/certificates/create/json/accepted";
            builder.withSubscription(subscription0);
            String subscription1 = "$aws/certificates/create/json/rejected";
            builder.withSubscription(subscription1);
            ResponsePath.ResponsePathBuilder pathBuilder1 = ResponsePath.builder();
            String responseTopic1 = publishTopic + "/accepted";
            pathBuilder1.withResponseTopic(publishTopic + "/accepted");
            builder.withResponsePath(pathBuilder1.build());
            ResponsePath.ResponsePathBuilder pathBuilder2 = ResponsePath.builder();
            String responseTopic2 = publishTopic + "/rejected";
            pathBuilder2.withResponseTopic(publishTopic + "/rejected");
            builder.withResponsePath(pathBuilder2.build());
            this.submitOperation(responseFuture, builder.build(), responseTopic1, CreateKeysAndCertificateResponse.class, responseTopic2, V2ErrorResponse.class, IotIdentityV2Client::createV2ErrorResponseException);
        }
        catch (Exception e) {
            responseFuture.completeExceptionally(IotIdentityV2Client.createV2ErrorResponseException(e.getMessage(), null));
        }
        return responseFuture;
    }

    public CompletableFuture<RegisterThingResponse> registerThing(RegisterThingRequest request) {
        V2ClientFuture<RegisterThingResponse> responseFuture = new V2ClientFuture<RegisterThingResponse>();
        try {
            if (request.templateName == null) {
                throw new CrtRuntimeException("RegisterThingRequest.templateName cannot be null");
            }
            RequestResponseOperation.RequestResponseOperationBuilder builder = RequestResponseOperation.builder();
            String publishTopic = "$aws/provisioning-templates/{templateName}/provision/json";
            publishTopic = publishTopic.replace("{templateName}", request.templateName);
            builder.withPublishTopic(publishTopic);
            String payloadJson = this.gson.toJson((Object)request);
            builder.withPayload(payloadJson.getBytes(StandardCharsets.UTF_8));
            String subscription0 = "$aws/provisioning-templates/{templateName}/provision/json/accepted";
            subscription0 = subscription0.replace("{templateName}", request.templateName);
            builder.withSubscription(subscription0);
            String subscription1 = "$aws/provisioning-templates/{templateName}/provision/json/rejected";
            subscription1 = subscription1.replace("{templateName}", request.templateName);
            builder.withSubscription(subscription1);
            ResponsePath.ResponsePathBuilder pathBuilder1 = ResponsePath.builder();
            String responseTopic1 = publishTopic + "/accepted";
            pathBuilder1.withResponseTopic(publishTopic + "/accepted");
            builder.withResponsePath(pathBuilder1.build());
            ResponsePath.ResponsePathBuilder pathBuilder2 = ResponsePath.builder();
            String responseTopic2 = publishTopic + "/rejected";
            pathBuilder2.withResponseTopic(publishTopic + "/rejected");
            builder.withResponsePath(pathBuilder2.build());
            this.submitOperation(responseFuture, builder.build(), responseTopic1, RegisterThingResponse.class, responseTopic2, V2ErrorResponse.class, IotIdentityV2Client::createV2ErrorResponseException);
        }
        catch (Exception e) {
            responseFuture.completeExceptionally(IotIdentityV2Client.createV2ErrorResponseException(e.getMessage(), null));
        }
        return responseFuture;
    }

    private static Throwable createV2ErrorResponseException(String message, V2ErrorResponse errorResponse) {
        return new V2ErrorResponseException(message, errorResponse);
    }

    private <T, E> void submitOperation(V2ClientFuture<T> finalFuture, RequestResponseOperation operation, String responseTopic, Class<T> responseClass, String errorTopic, Class<E> errorClass, BiFunction<String, E, Throwable> exceptionFactory) {
        try {
            CompletableFuture responseFuture = this.rrClient.submitRequest(operation);
            CompletionStage compositeFuture = responseFuture.whenComplete((res, ex) -> {
                if (ex != null) {
                    finalFuture.completeExceptionally((Throwable)exceptionFactory.apply(ex.getMessage(), null));
                } else if (res.getTopic().equals(responseTopic)) {
                    try {
                        String payload = new String(res.getPayload(), StandardCharsets.UTF_8);
                        Object response = this.gson.fromJson(payload, responseClass);
                        finalFuture.complete(response);
                    }
                    catch (Exception e) {
                        finalFuture.completeExceptionally((Throwable)exceptionFactory.apply(e.getMessage(), null));
                    }
                } else if (res.getTopic().equals(errorTopic)) {
                    try {
                        String payload = new String(res.getPayload(), StandardCharsets.UTF_8);
                        Object error = this.gson.fromJson(payload, errorClass);
                        finalFuture.completeExceptionally((Throwable)exceptionFactory.apply("Request-response operation failure", error));
                    }
                    catch (Exception e) {
                        finalFuture.completeExceptionally((Throwable)exceptionFactory.apply(e.getMessage(), null));
                    }
                } else {
                    finalFuture.completeExceptionally((Throwable)exceptionFactory.apply("Request-response operation completed on unknown topic: " + res.getTopic(), null));
                }
            });
            finalFuture.setTriggeringFuture((CompletableFuture<MqttRequestResponse>)compositeFuture);
        }
        catch (Exception ex2) {
            finalFuture.completeExceptionally(exceptionFactory.apply(ex2.getMessage(), null));
        }
    }
}

