/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ioteventsdata.model.DetectorStateSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectorSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectorSummary> {
    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DetectorSummary.getter(DetectorSummary::detectorModelName)).setter(DetectorSummary.setter(Builder::detectorModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelName").build()}).build();
    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DetectorSummary.getter(DetectorSummary::keyValue)).setter(DetectorSummary.setter(Builder::keyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyValue").build()}).build();
    private static final SdkField<String> DETECTOR_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DetectorSummary.getter(DetectorSummary::detectorModelVersion)).setter(DetectorSummary.setter(Builder::detectorModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelVersion").build()}).build();
    private static final SdkField<DetectorStateSummary> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DetectorSummary.getter(DetectorSummary::state)).setter(DetectorSummary.setter(Builder::state)).constructor(DetectorStateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DetectorSummary.getter(DetectorSummary::creationTime)).setter(DetectorSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DetectorSummary.getter(DetectorSummary::lastUpdateTime)).setter(DetectorSummary.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_NAME_FIELD, KEY_VALUE_FIELD, DETECTOR_MODEL_VERSION_FIELD, STATE_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String detectorModelName;
    private final String keyValue;
    private final String detectorModelVersion;
    private final DetectorStateSummary state;
    private final Instant creationTime;
    private final Instant lastUpdateTime;

    private DetectorSummary(BuilderImpl builder) {
        this.detectorModelName = builder.detectorModelName;
        this.keyValue = builder.keyValue;
        this.detectorModelVersion = builder.detectorModelVersion;
        this.state = builder.state;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public String detectorModelName() {
        return this.detectorModelName;
    }

    public String keyValue() {
        return this.keyValue;
    }

    public String detectorModelVersion() {
        return this.detectorModelVersion;
    }

    public DetectorStateSummary state() {
        return this.state;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorSummary)) {
            return false;
        }
        DetectorSummary other = (DetectorSummary)obj;
        return Objects.equals(this.detectorModelName(), other.detectorModelName()) && Objects.equals(this.keyValue(), other.keyValue()) && Objects.equals(this.detectorModelVersion(), other.detectorModelVersion()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public String toString() {
        return ToString.builder((String)"DetectorSummary").add("DetectorModelName", (Object)this.detectorModelName()).add("KeyValue", (Object)this.keyValue()).add("DetectorModelVersion", (Object)this.detectorModelVersion()).add("State", (Object)this.state()).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorModelName": {
                return Optional.ofNullable(clazz.cast(this.detectorModelName()));
            }
            case "keyValue": {
                return Optional.ofNullable(clazz.cast(this.keyValue()));
            }
            case "detectorModelVersion": {
                return Optional.ofNullable(clazz.cast(this.detectorModelVersion()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectorSummary, T> g) {
        return obj -> g.apply((DetectorSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String detectorModelName;
        private String keyValue;
        private String detectorModelVersion;
        private DetectorStateSummary state;
        private Instant creationTime;
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorSummary model) {
            this.detectorModelName(model.detectorModelName);
            this.keyValue(model.keyValue);
            this.detectorModelVersion(model.detectorModelVersion);
            this.state(model.state);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getDetectorModelName() {
            return this.detectorModelName;
        }

        @Override
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        public final String getKeyValue() {
            return this.keyValue;
        }

        @Override
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        public final String getDetectorModelVersion() {
            return this.detectorModelVersion;
        }

        @Override
        public final Builder detectorModelVersion(String detectorModelVersion) {
            this.detectorModelVersion = detectorModelVersion;
            return this;
        }

        public final void setDetectorModelVersion(String detectorModelVersion) {
            this.detectorModelVersion = detectorModelVersion;
        }

        public final DetectorStateSummary.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        @Override
        public final Builder state(DetectorStateSummary state) {
            this.state = state;
            return this;
        }

        public final void setState(DetectorStateSummary.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public DetectorSummary build() {
            return new DetectorSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectorSummary> {
        public Builder detectorModelName(String var1);

        public Builder keyValue(String var1);

        public Builder detectorModelVersion(String var1);

        public Builder state(DetectorStateSummary var1);

        default public Builder state(Consumer<DetectorStateSummary.Builder> state) {
            return this.state((DetectorStateSummary)((DetectorStateSummary.Builder)DetectorStateSummary.builder().applyMutation(state)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

