/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration information of an acknowledge action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcknowledgeActionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AcknowledgeActionConfiguration.Builder, AcknowledgeActionConfiguration> {
    private static final SdkField<String> NOTE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("note")
            .getter(getter(AcknowledgeActionConfiguration::note)).setter(setter(Builder::note))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("note").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String note;

    private AcknowledgeActionConfiguration(BuilderImpl builder) {
        this.note = builder.note;
    }

    /**
     * <p>
     * The note that you can leave when you acknowledge the alarm.
     * </p>
     * 
     * @return The note that you can leave when you acknowledge the alarm.
     */
    public final String note() {
        return note;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(note());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcknowledgeActionConfiguration)) {
            return false;
        }
        AcknowledgeActionConfiguration other = (AcknowledgeActionConfiguration) obj;
        return Objects.equals(note(), other.note());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcknowledgeActionConfiguration").add("Note", note()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "note":
            return Optional.ofNullable(clazz.cast(note()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcknowledgeActionConfiguration, T> g) {
        return obj -> g.apply((AcknowledgeActionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AcknowledgeActionConfiguration> {
        /**
         * <p>
         * The note that you can leave when you acknowledge the alarm.
         * </p>
         * 
         * @param note
         *        The note that you can leave when you acknowledge the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder note(String note);
    }

    static final class BuilderImpl implements Builder {
        private String note;

        private BuilderImpl() {
        }

        private BuilderImpl(AcknowledgeActionConfiguration model) {
            note(model.note);
        }

        public final String getNote() {
            return note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        @Override
        @Transient
        public final Builder note(String note) {
            this.note = note;
            return this;
        }

        @Override
        public AcknowledgeActionConfiguration build() {
            return new AcknowledgeActionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
