/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a summary of an alarm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlarmSummary implements SdkPojo, Serializable, ToCopyableBuilder<AlarmSummary.Builder, AlarmSummary> {
    private static final SdkField<String> ALARM_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelName").getter(getter(AlarmSummary::alarmModelName)).setter(setter(Builder::alarmModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelName").build()).build();

    private static final SdkField<String> ALARM_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelVersion").getter(getter(AlarmSummary::alarmModelVersion))
            .setter(setter(Builder::alarmModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelVersion").build()).build();

    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyValue").getter(getter(AlarmSummary::keyValue)).setter(setter(Builder::keyValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyValue").build()).build();

    private static final SdkField<String> STATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateName").getter(getter(AlarmSummary::stateNameAsString)).setter(setter(Builder::stateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(AlarmSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(AlarmSummary::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_MODEL_NAME_FIELD,
            ALARM_MODEL_VERSION_FIELD, KEY_VALUE_FIELD, STATE_NAME_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String alarmModelName;

    private final String alarmModelVersion;

    private final String keyValue;

    private final String stateName;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private AlarmSummary(BuilderImpl builder) {
        this.alarmModelName = builder.alarmModelName;
        this.alarmModelVersion = builder.alarmModelVersion;
        this.keyValue = builder.keyValue;
        this.stateName = builder.stateName;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The name of the alarm model.
     * </p>
     * 
     * @return The name of the alarm model.
     */
    public final String alarmModelName() {
        return alarmModelName;
    }

    /**
     * <p>
     * The version of the alarm model.
     * </p>
     * 
     * @return The version of the alarm model.
     */
    public final String alarmModelVersion() {
        return alarmModelVersion;
    }

    /**
     * <p>
     * The value of the key used as a filter to select only the alarms associated with the <a href=
     * "https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key"
     * >key</a>.
     * </p>
     * 
     * @return The value of the key used as a filter to select only the alarms associated with the <a href=
     *         "https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key"
     *         >key</a>.
     */
    public final String keyValue() {
        return keyValue;
    }

    /**
     * <p>
     * The name of the alarm state. The state name can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state, it isn't ready to evaluate data. To
     * enable the alarm, you must change the alarm to the <code>NORMAL</code> state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state, it's ready to evaluate data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state, the alarm is invoked.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state, the alarm was invoked and
     * you acknowledged the alarm.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state, the alarm is disabled
     * for a specified period of time. After the snooze time, the alarm automatically changes to the <code>NORMAL</code>
     * state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state, the alarm was invoked. However, the
     * data that the alarm is currently evaluating is within the specified range. To change the alarm to the
     * <code>NORMAL</code> state, you must acknowledge the alarm.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateName} will
     * return {@link AlarmStateName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateNameAsString}.
     * </p>
     * 
     * @return The name of the alarm state. The state name can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state, it isn't ready to evaluate
     *         data. To enable the alarm, you must change the alarm to the <code>NORMAL</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state, it's ready to evaluate data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state, the alarm is invoked.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state, the alarm was
     *         invoked and you acknowledged the alarm.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state, the alarm is
     *         disabled for a specified period of time. After the snooze time, the alarm automatically changes to the
     *         <code>NORMAL</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state, the alarm was invoked.
     *         However, the data that the alarm is currently evaluating is within the specified range. To change the
     *         alarm to the <code>NORMAL</code> state, you must acknowledge the alarm.
     *         </p>
     *         </li>
     * @see AlarmStateName
     */
    public final AlarmStateName stateName() {
        return AlarmStateName.fromValue(stateName);
    }

    /**
     * <p>
     * The name of the alarm state. The state name can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state, it isn't ready to evaluate data. To
     * enable the alarm, you must change the alarm to the <code>NORMAL</code> state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state, it's ready to evaluate data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state, the alarm is invoked.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state, the alarm was invoked and
     * you acknowledged the alarm.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state, the alarm is disabled
     * for a specified period of time. After the snooze time, the alarm automatically changes to the <code>NORMAL</code>
     * state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state, the alarm was invoked. However, the
     * data that the alarm is currently evaluating is within the specified range. To change the alarm to the
     * <code>NORMAL</code> state, you must acknowledge the alarm.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateName} will
     * return {@link AlarmStateName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateNameAsString}.
     * </p>
     * 
     * @return The name of the alarm state. The state name can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state, it isn't ready to evaluate
     *         data. To enable the alarm, you must change the alarm to the <code>NORMAL</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state, it's ready to evaluate data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state, the alarm is invoked.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state, the alarm was
     *         invoked and you acknowledged the alarm.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state, the alarm is
     *         disabled for a specified period of time. After the snooze time, the alarm automatically changes to the
     *         <code>NORMAL</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state, the alarm was invoked.
     *         However, the data that the alarm is currently evaluating is within the specified range. To change the
     *         alarm to the <code>NORMAL</code> state, you must acknowledge the alarm.
     *         </p>
     *         </li>
     * @see AlarmStateName
     */
    public final String stateNameAsString() {
        return stateName;
    }

    /**
     * <p>
     * The time the alarm was created, in the Unix epoch format.
     * </p>
     * 
     * @return The time the alarm was created, in the Unix epoch format.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the alarm was last updated, in the Unix epoch format.
     * </p>
     * 
     * @return The time the alarm was last updated, in the Unix epoch format.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelName());
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(keyValue());
        hashCode = 31 * hashCode + Objects.hashCode(stateNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmSummary)) {
            return false;
        }
        AlarmSummary other = (AlarmSummary) obj;
        return Objects.equals(alarmModelName(), other.alarmModelName())
                && Objects.equals(alarmModelVersion(), other.alarmModelVersion()) && Objects.equals(keyValue(), other.keyValue())
                && Objects.equals(stateNameAsString(), other.stateNameAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlarmSummary").add("AlarmModelName", alarmModelName())
                .add("AlarmModelVersion", alarmModelVersion()).add("KeyValue", keyValue()).add("StateName", stateNameAsString())
                .add("CreationTime", creationTime()).add("LastUpdateTime", lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alarmModelName":
            return Optional.ofNullable(clazz.cast(alarmModelName()));
        case "alarmModelVersion":
            return Optional.ofNullable(clazz.cast(alarmModelVersion()));
        case "keyValue":
            return Optional.ofNullable(clazz.cast(keyValue()));
        case "stateName":
            return Optional.ofNullable(clazz.cast(stateNameAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlarmSummary, T> g) {
        return obj -> g.apply((AlarmSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlarmSummary> {
        /**
         * <p>
         * The name of the alarm model.
         * </p>
         * 
         * @param alarmModelName
         *        The name of the alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelName(String alarmModelName);

        /**
         * <p>
         * The version of the alarm model.
         * </p>
         * 
         * @param alarmModelVersion
         *        The version of the alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelVersion(String alarmModelVersion);

        /**
         * <p>
         * The value of the key used as a filter to select only the alarms associated with the <a href=
         * "https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key"
         * >key</a>.
         * </p>
         * 
         * @param keyValue
         *        The value of the key used as a filter to select only the alarms associated with the <a href=
         *        "https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key"
         *        >key</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyValue(String keyValue);

        /**
         * <p>
         * The name of the alarm state. The state name can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state, it isn't ready to evaluate
         * data. To enable the alarm, you must change the alarm to the <code>NORMAL</code> state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state, it's ready to evaluate data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state, the alarm is invoked.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state, the alarm was invoked
         * and you acknowledged the alarm.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state, the alarm is
         * disabled for a specified period of time. After the snooze time, the alarm automatically changes to the
         * <code>NORMAL</code> state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state, the alarm was invoked. However,
         * the data that the alarm is currently evaluating is within the specified range. To change the alarm to the
         * <code>NORMAL</code> state, you must acknowledge the alarm.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stateName
         *        The name of the alarm state. The state name can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state, it isn't ready to
         *        evaluate data. To enable the alarm, you must change the alarm to the <code>NORMAL</code> state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state, it's ready to evaluate data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state, the alarm is invoked.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state, the alarm was
         *        invoked and you acknowledged the alarm.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state, the alarm
         *        is disabled for a specified period of time. After the snooze time, the alarm automatically changes to
         *        the <code>NORMAL</code> state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state, the alarm was invoked.
         *        However, the data that the alarm is currently evaluating is within the specified range. To change the
         *        alarm to the <code>NORMAL</code> state, you must acknowledge the alarm.
         *        </p>
         *        </li>
         * @see AlarmStateName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlarmStateName
         */
        Builder stateName(String stateName);

        /**
         * <p>
         * The name of the alarm state. The state name can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state, it isn't ready to evaluate
         * data. To enable the alarm, you must change the alarm to the <code>NORMAL</code> state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state, it's ready to evaluate data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state, the alarm is invoked.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state, the alarm was invoked
         * and you acknowledged the alarm.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state, the alarm is
         * disabled for a specified period of time. After the snooze time, the alarm automatically changes to the
         * <code>NORMAL</code> state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state, the alarm was invoked. However,
         * the data that the alarm is currently evaluating is within the specified range. To change the alarm to the
         * <code>NORMAL</code> state, you must acknowledge the alarm.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stateName
         *        The name of the alarm state. The state name can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state, it isn't ready to
         *        evaluate data. To enable the alarm, you must change the alarm to the <code>NORMAL</code> state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state, it's ready to evaluate data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state, the alarm is invoked.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state, the alarm was
         *        invoked and you acknowledged the alarm.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state, the alarm
         *        is disabled for a specified period of time. After the snooze time, the alarm automatically changes to
         *        the <code>NORMAL</code> state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state, the alarm was invoked.
         *        However, the data that the alarm is currently evaluating is within the specified range. To change the
         *        alarm to the <code>NORMAL</code> state, you must acknowledge the alarm.
         *        </p>
         *        </li>
         * @see AlarmStateName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlarmStateName
         */
        Builder stateName(AlarmStateName stateName);

        /**
         * <p>
         * The time the alarm was created, in the Unix epoch format.
         * </p>
         * 
         * @param creationTime
         *        The time the alarm was created, in the Unix epoch format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the alarm was last updated, in the Unix epoch format.
         * </p>
         * 
         * @param lastUpdateTime
         *        The time the alarm was last updated, in the Unix epoch format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String alarmModelName;

        private String alarmModelVersion;

        private String keyValue;

        private String stateName;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmSummary model) {
            alarmModelName(model.alarmModelName);
            alarmModelVersion(model.alarmModelVersion);
            keyValue(model.keyValue);
            stateName(model.stateName);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getAlarmModelName() {
            return alarmModelName;
        }

        public final void setAlarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
        }

        @Override
        @Transient
        public final Builder alarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        public final String getAlarmModelVersion() {
            return alarmModelVersion;
        }

        public final void setAlarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
        }

        @Override
        @Transient
        public final Builder alarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
            return this;
        }

        public final String getKeyValue() {
            return keyValue;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        @Transient
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public final String getStateName() {
            return stateName;
        }

        public final void setStateName(String stateName) {
            this.stateName = stateName;
        }

        @Override
        @Transient
        public final Builder stateName(String stateName) {
            this.stateName = stateName;
            return this;
        }

        @Override
        @Transient
        public final Builder stateName(AlarmStateName stateName) {
            this.stateName(stateName == null ? null : stateName.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Override
        public AlarmSummary build() {
            return new AlarmSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
