/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about alarm state changes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SystemEvent implements SdkPojo, Serializable, ToCopyableBuilder<SystemEvent.Builder, SystemEvent> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(SystemEvent::eventTypeAsString)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<StateChangeConfiguration> STATE_CHANGE_CONFIGURATION_FIELD = SdkField
            .<StateChangeConfiguration> builder(MarshallingType.SDK_POJO).memberName("stateChangeConfiguration")
            .getter(getter(SystemEvent::stateChangeConfiguration)).setter(setter(Builder::stateChangeConfiguration))
            .constructor(StateChangeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateChangeConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD,
            STATE_CHANGE_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eventType;

    private final StateChangeConfiguration stateChangeConfiguration;

    private SystemEvent(BuilderImpl builder) {
        this.eventType = builder.eventType;
        this.stateChangeConfiguration = builder.stateChangeConfiguration;
    }

    /**
     * <p>
     * The event type. If the value is <code>STATE_CHANGE</code>, the event contains information about alarm state
     * changes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The event type. If the value is <code>STATE_CHANGE</code>, the event contains information about alarm
     *         state changes.
     * @see EventType
     */
    public final EventType eventType() {
        return EventType.fromValue(eventType);
    }

    /**
     * <p>
     * The event type. If the value is <code>STATE_CHANGE</code>, the event contains information about alarm state
     * changes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The event type. If the value is <code>STATE_CHANGE</code>, the event contains information about alarm
     *         state changes.
     * @see EventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * Contains the configuration information of alarm state changes.
     * </p>
     * 
     * @return Contains the configuration information of alarm state changes.
     */
    public final StateChangeConfiguration stateChangeConfiguration() {
        return stateChangeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateChangeConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemEvent)) {
            return false;
        }
        SystemEvent other = (SystemEvent) obj;
        return Objects.equals(eventTypeAsString(), other.eventTypeAsString())
                && Objects.equals(stateChangeConfiguration(), other.stateChangeConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SystemEvent").add("EventType", eventTypeAsString())
                .add("StateChangeConfiguration", stateChangeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "stateChangeConfiguration":
            return Optional.ofNullable(clazz.cast(stateChangeConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SystemEvent, T> g) {
        return obj -> g.apply((SystemEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SystemEvent> {
        /**
         * <p>
         * The event type. If the value is <code>STATE_CHANGE</code>, the event contains information about alarm state
         * changes.
         * </p>
         * 
         * @param eventType
         *        The event type. If the value is <code>STATE_CHANGE</code>, the event contains information about alarm
         *        state changes.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The event type. If the value is <code>STATE_CHANGE</code>, the event contains information about alarm state
         * changes.
         * </p>
         * 
         * @param eventType
         *        The event type. If the value is <code>STATE_CHANGE</code>, the event contains information about alarm
         *        state changes.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(EventType eventType);

        /**
         * <p>
         * Contains the configuration information of alarm state changes.
         * </p>
         * 
         * @param stateChangeConfiguration
         *        Contains the configuration information of alarm state changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateChangeConfiguration(StateChangeConfiguration stateChangeConfiguration);

        /**
         * <p>
         * Contains the configuration information of alarm state changes.
         * </p>
         * This is a convenience that creates an instance of the {@link StateChangeConfiguration.Builder} avoiding the
         * need to create one manually via {@link StateChangeConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link StateChangeConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #stateChangeConfiguration(StateChangeConfiguration)}.
         * 
         * @param stateChangeConfiguration
         *        a consumer that will call methods on {@link StateChangeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateChangeConfiguration(StateChangeConfiguration)
         */
        default Builder stateChangeConfiguration(Consumer<StateChangeConfiguration.Builder> stateChangeConfiguration) {
            return stateChangeConfiguration(StateChangeConfiguration.builder().applyMutation(stateChangeConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String eventType;

        private StateChangeConfiguration stateChangeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SystemEvent model) {
            eventType(model.eventType);
            stateChangeConfiguration(model.stateChangeConfiguration);
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        @Transient
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        @Transient
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final StateChangeConfiguration.Builder getStateChangeConfiguration() {
            return stateChangeConfiguration != null ? stateChangeConfiguration.toBuilder() : null;
        }

        public final void setStateChangeConfiguration(StateChangeConfiguration.BuilderImpl stateChangeConfiguration) {
            this.stateChangeConfiguration = stateChangeConfiguration != null ? stateChangeConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder stateChangeConfiguration(StateChangeConfiguration stateChangeConfiguration) {
            this.stateChangeConfiguration = stateChangeConfiguration;
            return this;
        }

        @Override
        public SystemEvent build() {
            return new SystemEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
