/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDetectorResponse extends IotEventsDataResponse implements
        ToCopyableBuilder<DescribeDetectorResponse.Builder, DescribeDetectorResponse> {
    private static final SdkField<Detector> DETECTOR_FIELD = SdkField.<Detector> builder(MarshallingType.SDK_POJO)
            .memberName("detector").getter(getter(DescribeDetectorResponse::detector)).setter(setter(Builder::detector))
            .constructor(Detector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detector").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_FIELD));

    private final Detector detector;

    private DescribeDetectorResponse(BuilderImpl builder) {
        super(builder);
        this.detector = builder.detector;
    }

    /**
     * <p>
     * Information about the detector (instance).
     * </p>
     * 
     * @return Information about the detector (instance).
     */
    public final Detector detector() {
        return detector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDetectorResponse)) {
            return false;
        }
        DescribeDetectorResponse other = (DescribeDetectorResponse) obj;
        return Objects.equals(detector(), other.detector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDetectorResponse").add("Detector", detector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detector":
            return Optional.ofNullable(clazz.cast(detector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDetectorResponse, T> g) {
        return obj -> g.apply((DescribeDetectorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDetectorResponse> {
        /**
         * <p>
         * Information about the detector (instance).
         * </p>
         * 
         * @param detector
         *        Information about the detector (instance).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detector(Detector detector);

        /**
         * <p>
         * Information about the detector (instance).
         * </p>
         * This is a convenience method that creates an instance of the {@link Detector.Builder} avoiding the need to
         * create one manually via {@link Detector#builder()}.
         *
         * When the {@link Consumer} completes, {@link Detector.Builder#build()} is called immediately and its result is
         * passed to {@link #detector(Detector)}.
         * 
         * @param detector
         *        a consumer that will call methods on {@link Detector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detector(Detector)
         */
        default Builder detector(Consumer<Detector.Builder> detector) {
            return detector(Detector.builder().applyMutation(detector).build());
        }
    }

    static final class BuilderImpl extends IotEventsDataResponse.BuilderImpl implements Builder {
        private Detector detector;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDetectorResponse model) {
            super(model);
            detector(model.detector);
        }

        public final Detector.Builder getDetector() {
            return detector != null ? detector.toBuilder() : null;
        }

        public final void setDetector(Detector.BuilderImpl detector) {
            this.detector = detector != null ? detector.build() : null;
        }

        @Override
        public final Builder detector(Detector detector) {
            this.detector = detector;
            return this;
        }

        @Override
        public DescribeDetectorResponse build() {
            return new DescribeDetectorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
