/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration information of alarm state changes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StateChangeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<StateChangeConfiguration.Builder, StateChangeConfiguration> {
    private static final SdkField<String> TRIGGER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("triggerType").getter(getter(StateChangeConfiguration::triggerTypeAsString))
            .setter(setter(Builder::triggerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIGGER_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String triggerType;

    private StateChangeConfiguration(BuilderImpl builder) {
        this.triggerType = builder.triggerType;
    }

    /**
     * <p>
     * The trigger type. If the value is <code>SNOOZE_TIMEOUT</code>, the snooze duration ends and the alarm
     * automatically changes to the <code>NORMAL</code> state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #triggerType} will
     * return {@link TriggerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #triggerTypeAsString}.
     * </p>
     * 
     * @return The trigger type. If the value is <code>SNOOZE_TIMEOUT</code>, the snooze duration ends and the alarm
     *         automatically changes to the <code>NORMAL</code> state.
     * @see TriggerType
     */
    public final TriggerType triggerType() {
        return TriggerType.fromValue(triggerType);
    }

    /**
     * <p>
     * The trigger type. If the value is <code>SNOOZE_TIMEOUT</code>, the snooze duration ends and the alarm
     * automatically changes to the <code>NORMAL</code> state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #triggerType} will
     * return {@link TriggerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #triggerTypeAsString}.
     * </p>
     * 
     * @return The trigger type. If the value is <code>SNOOZE_TIMEOUT</code>, the snooze duration ends and the alarm
     *         automatically changes to the <code>NORMAL</code> state.
     * @see TriggerType
     */
    public final String triggerTypeAsString() {
        return triggerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(triggerTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StateChangeConfiguration)) {
            return false;
        }
        StateChangeConfiguration other = (StateChangeConfiguration) obj;
        return Objects.equals(triggerTypeAsString(), other.triggerTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StateChangeConfiguration").add("TriggerType", triggerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "triggerType":
            return Optional.ofNullable(clazz.cast(triggerTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StateChangeConfiguration, T> g) {
        return obj -> g.apply((StateChangeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StateChangeConfiguration> {
        /**
         * <p>
         * The trigger type. If the value is <code>SNOOZE_TIMEOUT</code>, the snooze duration ends and the alarm
         * automatically changes to the <code>NORMAL</code> state.
         * </p>
         * 
         * @param triggerType
         *        The trigger type. If the value is <code>SNOOZE_TIMEOUT</code>, the snooze duration ends and the alarm
         *        automatically changes to the <code>NORMAL</code> state.
         * @see TriggerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerType
         */
        Builder triggerType(String triggerType);

        /**
         * <p>
         * The trigger type. If the value is <code>SNOOZE_TIMEOUT</code>, the snooze duration ends and the alarm
         * automatically changes to the <code>NORMAL</code> state.
         * </p>
         * 
         * @param triggerType
         *        The trigger type. If the value is <code>SNOOZE_TIMEOUT</code>, the snooze duration ends and the alarm
         *        automatically changes to the <code>NORMAL</code> state.
         * @see TriggerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerType
         */
        Builder triggerType(TriggerType triggerType);
    }

    static final class BuilderImpl implements Builder {
        private String triggerType;

        private BuilderImpl() {
        }

        private BuilderImpl(StateChangeConfiguration model) {
            triggerType(model.triggerType);
        }

        public final String getTriggerType() {
            return triggerType;
        }

        public final void setTriggerType(String triggerType) {
            this.triggerType = triggerType;
        }

        @Override
        public final Builder triggerType(String triggerType) {
            this.triggerType = triggerType;
            return this;
        }

        @Override
        public final Builder triggerType(TriggerType triggerType) {
            this.triggerType(triggerType == null ? null : triggerType.toString());
            return this;
        }

        @Override
        public StateChangeConfiguration build() {
            return new StateChangeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
