/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateDetectorResponse extends IotEventsDataResponse implements
        ToCopyableBuilder<BatchUpdateDetectorResponse.Builder, BatchUpdateDetectorResponse> {
    private static final SdkField<List<BatchUpdateDetectorErrorEntry>> BATCH_UPDATE_DETECTOR_ERROR_ENTRIES_FIELD = SdkField
            .<List<BatchUpdateDetectorErrorEntry>> builder(MarshallingType.LIST)
            .memberName("batchUpdateDetectorErrorEntries")
            .getter(getter(BatchUpdateDetectorResponse::batchUpdateDetectorErrorEntries))
            .setter(setter(Builder::batchUpdateDetectorErrorEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchUpdateDetectorErrorEntries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchUpdateDetectorErrorEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchUpdateDetectorErrorEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BATCH_UPDATE_DETECTOR_ERROR_ENTRIES_FIELD));

    private final List<BatchUpdateDetectorErrorEntry> batchUpdateDetectorErrorEntries;

    private BatchUpdateDetectorResponse(BuilderImpl builder) {
        super(builder);
        this.batchUpdateDetectorErrorEntries = builder.batchUpdateDetectorErrorEntries;
    }

    /**
     * For responses, this returns true if the service returned a value for the BatchUpdateDetectorErrorEntries
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasBatchUpdateDetectorErrorEntries() {
        return batchUpdateDetectorErrorEntries != null && !(batchUpdateDetectorErrorEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of those detector updates that resulted in errors. (If an error is listed here, the specific update did
     * not occur.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBatchUpdateDetectorErrorEntries}
     * method.
     * </p>
     * 
     * @return A list of those detector updates that resulted in errors. (If an error is listed here, the specific
     *         update did not occur.)
     */
    public final List<BatchUpdateDetectorErrorEntry> batchUpdateDetectorErrorEntries() {
        return batchUpdateDetectorErrorEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasBatchUpdateDetectorErrorEntries() ? batchUpdateDetectorErrorEntries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateDetectorResponse)) {
            return false;
        }
        BatchUpdateDetectorResponse other = (BatchUpdateDetectorResponse) obj;
        return hasBatchUpdateDetectorErrorEntries() == other.hasBatchUpdateDetectorErrorEntries()
                && Objects.equals(batchUpdateDetectorErrorEntries(), other.batchUpdateDetectorErrorEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BatchUpdateDetectorResponse")
                .add("BatchUpdateDetectorErrorEntries",
                        hasBatchUpdateDetectorErrorEntries() ? batchUpdateDetectorErrorEntries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "batchUpdateDetectorErrorEntries":
            return Optional.ofNullable(clazz.cast(batchUpdateDetectorErrorEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateDetectorResponse, T> g) {
        return obj -> g.apply((BatchUpdateDetectorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsDataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateDetectorResponse> {
        /**
         * <p>
         * A list of those detector updates that resulted in errors. (If an error is listed here, the specific update
         * did not occur.)
         * </p>
         * 
         * @param batchUpdateDetectorErrorEntries
         *        A list of those detector updates that resulted in errors. (If an error is listed here, the specific
         *        update did not occur.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchUpdateDetectorErrorEntries(Collection<BatchUpdateDetectorErrorEntry> batchUpdateDetectorErrorEntries);

        /**
         * <p>
         * A list of those detector updates that resulted in errors. (If an error is listed here, the specific update
         * did not occur.)
         * </p>
         * 
         * @param batchUpdateDetectorErrorEntries
         *        A list of those detector updates that resulted in errors. (If an error is listed here, the specific
         *        update did not occur.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchUpdateDetectorErrorEntries(BatchUpdateDetectorErrorEntry... batchUpdateDetectorErrorEntries);

        /**
         * <p>
         * A list of those detector updates that resulted in errors. (If an error is listed here, the specific update
         * did not occur.)
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchUpdateDetectorErrorEntry>.Builder}
         * avoiding the need to create one manually via {@link List<BatchUpdateDetectorErrorEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchUpdateDetectorErrorEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #batchUpdateDetectorErrorEntries(List<BatchUpdateDetectorErrorEntry>)}.
         * 
         * @param batchUpdateDetectorErrorEntries
         *        a consumer that will call methods on {@link List<BatchUpdateDetectorErrorEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchUpdateDetectorErrorEntries(List<BatchUpdateDetectorErrorEntry>)
         */
        Builder batchUpdateDetectorErrorEntries(
                Consumer<BatchUpdateDetectorErrorEntry.Builder>... batchUpdateDetectorErrorEntries);
    }

    static final class BuilderImpl extends IotEventsDataResponse.BuilderImpl implements Builder {
        private List<BatchUpdateDetectorErrorEntry> batchUpdateDetectorErrorEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateDetectorResponse model) {
            super(model);
            batchUpdateDetectorErrorEntries(model.batchUpdateDetectorErrorEntries);
        }

        public final List<BatchUpdateDetectorErrorEntry.Builder> getBatchUpdateDetectorErrorEntries() {
            List<BatchUpdateDetectorErrorEntry.Builder> result = BatchUpdateDetectorErrorEntriesCopier
                    .copyToBuilder(this.batchUpdateDetectorErrorEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBatchUpdateDetectorErrorEntries(
                Collection<BatchUpdateDetectorErrorEntry.BuilderImpl> batchUpdateDetectorErrorEntries) {
            this.batchUpdateDetectorErrorEntries = BatchUpdateDetectorErrorEntriesCopier
                    .copyFromBuilder(batchUpdateDetectorErrorEntries);
        }

        @Override
        @Transient
        public final Builder batchUpdateDetectorErrorEntries(
                Collection<BatchUpdateDetectorErrorEntry> batchUpdateDetectorErrorEntries) {
            this.batchUpdateDetectorErrorEntries = BatchUpdateDetectorErrorEntriesCopier.copy(batchUpdateDetectorErrorEntries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder batchUpdateDetectorErrorEntries(BatchUpdateDetectorErrorEntry... batchUpdateDetectorErrorEntries) {
            batchUpdateDetectorErrorEntries(Arrays.asList(batchUpdateDetectorErrorEntries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder batchUpdateDetectorErrorEntries(
                Consumer<BatchUpdateDetectorErrorEntry.Builder>... batchUpdateDetectorErrorEntries) {
            batchUpdateDetectorErrorEntries(Stream.of(batchUpdateDetectorErrorEntries)
                    .map(c -> BatchUpdateDetectorErrorEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateDetectorResponse build() {
            return new BatchUpdateDetectorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
