/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the current state of the detector instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectorState implements SdkPojo, Serializable, ToCopyableBuilder<DetectorState.Builder, DetectorState> {
    private static final SdkField<String> STATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateName").getter(getter(DetectorState::stateName)).setter(setter(Builder::stateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateName").build()).build();

    private static final SdkField<List<Variable>> VARIABLES_FIELD = SdkField
            .<List<Variable>> builder(MarshallingType.LIST)
            .memberName("variables")
            .getter(getter(DetectorState::variables))
            .setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Variable> builder(MarshallingType.SDK_POJO)
                                            .constructor(Variable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Timer>> TIMERS_FIELD = SdkField
            .<List<Timer>> builder(MarshallingType.LIST)
            .memberName("timers")
            .getter(getter(DetectorState::timers))
            .setter(setter(Builder::timers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Timer> builder(MarshallingType.SDK_POJO)
                                            .constructor(Timer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_NAME_FIELD,
            VARIABLES_FIELD, TIMERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stateName;

    private final List<Variable> variables;

    private final List<Timer> timers;

    private DetectorState(BuilderImpl builder) {
        this.stateName = builder.stateName;
        this.variables = builder.variables;
        this.timers = builder.timers;
    }

    /**
     * <p>
     * The name of the state.
     * </p>
     * 
     * @return The name of the state.
     */
    public final String stateName() {
        return stateName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Variables property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVariables() {
        return variables != null && !(variables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The current values of the detector's variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVariables} method.
     * </p>
     * 
     * @return The current values of the detector's variables.
     */
    public final List<Variable> variables() {
        return variables;
    }

    /**
     * For responses, this returns true if the service returned a value for the Timers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTimers() {
        return timers != null && !(timers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The current state of the detector's timers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimers} method.
     * </p>
     * 
     * @return The current state of the detector's timers.
     */
    public final List<Timer> timers() {
        return timers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateName());
        hashCode = 31 * hashCode + Objects.hashCode(hasVariables() ? variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTimers() ? timers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorState)) {
            return false;
        }
        DetectorState other = (DetectorState) obj;
        return Objects.equals(stateName(), other.stateName()) && hasVariables() == other.hasVariables()
                && Objects.equals(variables(), other.variables()) && hasTimers() == other.hasTimers()
                && Objects.equals(timers(), other.timers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectorState").add("StateName", stateName())
                .add("Variables", hasVariables() ? variables() : null).add("Timers", hasTimers() ? timers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateName":
            return Optional.ofNullable(clazz.cast(stateName()));
        case "variables":
            return Optional.ofNullable(clazz.cast(variables()));
        case "timers":
            return Optional.ofNullable(clazz.cast(timers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectorState, T> g) {
        return obj -> g.apply((DetectorState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectorState> {
        /**
         * <p>
         * The name of the state.
         * </p>
         * 
         * @param stateName
         *        The name of the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateName(String stateName);

        /**
         * <p>
         * The current values of the detector's variables.
         * </p>
         * 
         * @param variables
         *        The current values of the detector's variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Collection<Variable> variables);

        /**
         * <p>
         * The current values of the detector's variables.
         * </p>
         * 
         * @param variables
         *        The current values of the detector's variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Variable... variables);

        /**
         * <p>
         * The current values of the detector's variables.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Variable>.Builder} avoiding the need to
         * create one manually via {@link List<Variable>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Variable>.Builder#build()} is called immediately and its
         * result is passed to {@link #variables(List<Variable>)}.
         * 
         * @param variables
         *        a consumer that will call methods on {@link List<Variable>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #variables(List<Variable>)
         */
        Builder variables(Consumer<Variable.Builder>... variables);

        /**
         * <p>
         * The current state of the detector's timers.
         * </p>
         * 
         * @param timers
         *        The current state of the detector's timers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timers(Collection<Timer> timers);

        /**
         * <p>
         * The current state of the detector's timers.
         * </p>
         * 
         * @param timers
         *        The current state of the detector's timers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timers(Timer... timers);

        /**
         * <p>
         * The current state of the detector's timers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Timer>.Builder} avoiding the need to create
         * one manually via {@link List<Timer>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Timer>.Builder#build()} is called immediately and its result
         * is passed to {@link #timers(List<Timer>)}.
         * 
         * @param timers
         *        a consumer that will call methods on {@link List<Timer>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timers(List<Timer>)
         */
        Builder timers(Consumer<Timer.Builder>... timers);
    }

    static final class BuilderImpl implements Builder {
        private String stateName;

        private List<Variable> variables = DefaultSdkAutoConstructList.getInstance();

        private List<Timer> timers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorState model) {
            stateName(model.stateName);
            variables(model.variables);
            timers(model.timers);
        }

        public final String getStateName() {
            return stateName;
        }

        public final void setStateName(String stateName) {
            this.stateName = stateName;
        }

        @Override
        @Transient
        public final Builder stateName(String stateName) {
            this.stateName = stateName;
            return this;
        }

        public final List<Variable.Builder> getVariables() {
            List<Variable.Builder> result = VariablesCopier.copyToBuilder(this.variables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariables(Collection<Variable.BuilderImpl> variables) {
            this.variables = VariablesCopier.copyFromBuilder(variables);
        }

        @Override
        @Transient
        public final Builder variables(Collection<Variable> variables) {
            this.variables = VariablesCopier.copy(variables);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder variables(Variable... variables) {
            variables(Arrays.asList(variables));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder variables(Consumer<Variable.Builder>... variables) {
            variables(Stream.of(variables).map(c -> Variable.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Timer.Builder> getTimers() {
            List<Timer.Builder> result = TimersCopier.copyToBuilder(this.timers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimers(Collection<Timer.BuilderImpl> timers) {
            this.timers = TimersCopier.copyFromBuilder(timers);
        }

        @Override
        @Transient
        public final Builder timers(Collection<Timer> timers) {
            this.timers = TimersCopier.copy(timers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder timers(Timer... timers) {
            timers(Arrays.asList(timers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder timers(Consumer<Timer.Builder>... timers) {
            timers(Stream.of(timers).map(c -> Timer.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DetectorState build() {
            return new DetectorState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
