/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDetectorsResponse extends IotEventsDataResponse implements
        ToCopyableBuilder<ListDetectorsResponse.Builder, ListDetectorsResponse> {
    private static final SdkField<List<DetectorSummary>> DETECTOR_SUMMARIES_FIELD = SdkField
            .<List<DetectorSummary>> builder(MarshallingType.LIST)
            .memberName("detectorSummaries")
            .getter(getter(ListDetectorsResponse::detectorSummaries))
            .setter(setter(Builder::detectorSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DetectorSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DetectorSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDetectorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DetectorSummary> detectorSummaries;

    private final String nextToken;

    private ListDetectorsResponse(BuilderImpl builder) {
        super(builder);
        this.detectorSummaries = builder.detectorSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DetectorSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDetectorSummaries() {
        return detectorSummaries != null && !(detectorSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of summary information about the detectors (instances).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDetectorSummaries} method.
     * </p>
     * 
     * @return A list of summary information about the detectors (instances).
     */
    public final List<DetectorSummary> detectorSummaries() {
        return detectorSummaries;
    }

    /**
     * <p>
     * The token that you can use to return the next set of results, or <code>null</code> if there are no more results.
     * </p>
     * 
     * @return The token that you can use to return the next set of results, or <code>null</code> if there are no more
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDetectorSummaries() ? detectorSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDetectorsResponse)) {
            return false;
        }
        ListDetectorsResponse other = (ListDetectorsResponse) obj;
        return hasDetectorSummaries() == other.hasDetectorSummaries()
                && Objects.equals(detectorSummaries(), other.detectorSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDetectorsResponse")
                .add("DetectorSummaries", hasDetectorSummaries() ? detectorSummaries() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorSummaries":
            return Optional.ofNullable(clazz.cast(detectorSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDetectorsResponse, T> g) {
        return obj -> g.apply((ListDetectorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDetectorsResponse> {
        /**
         * <p>
         * A list of summary information about the detectors (instances).
         * </p>
         * 
         * @param detectorSummaries
         *        A list of summary information about the detectors (instances).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorSummaries(Collection<DetectorSummary> detectorSummaries);

        /**
         * <p>
         * A list of summary information about the detectors (instances).
         * </p>
         * 
         * @param detectorSummaries
         *        A list of summary information about the detectors (instances).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorSummaries(DetectorSummary... detectorSummaries);

        /**
         * <p>
         * A list of summary information about the detectors (instances).
         * </p>
         * This is a convenience that creates an instance of the {@link List<DetectorSummary>.Builder} avoiding the need
         * to create one manually via {@link List<DetectorSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DetectorSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #detectorSummaries(List<DetectorSummary>)}.
         * 
         * @param detectorSummaries
         *        a consumer that will call methods on {@link List<DetectorSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectorSummaries(List<DetectorSummary>)
         */
        Builder detectorSummaries(Consumer<DetectorSummary.Builder>... detectorSummaries);

        /**
         * <p>
         * The token that you can use to return the next set of results, or <code>null</code> if there are no more
         * results.
         * </p>
         * 
         * @param nextToken
         *        The token that you can use to return the next set of results, or <code>null</code> if there are no
         *        more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotEventsDataResponse.BuilderImpl implements Builder {
        private List<DetectorSummary> detectorSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDetectorsResponse model) {
            super(model);
            detectorSummaries(model.detectorSummaries);
            nextToken(model.nextToken);
        }

        public final List<DetectorSummary.Builder> getDetectorSummaries() {
            List<DetectorSummary.Builder> result = DetectorSummariesCopier.copyToBuilder(this.detectorSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetectorSummaries(Collection<DetectorSummary.BuilderImpl> detectorSummaries) {
            this.detectorSummaries = DetectorSummariesCopier.copyFromBuilder(detectorSummaries);
        }

        @Override
        @Transient
        public final Builder detectorSummaries(Collection<DetectorSummary> detectorSummaries) {
            this.detectorSummaries = DetectorSummariesCopier.copy(detectorSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder detectorSummaries(DetectorSummary... detectorSummaries) {
            detectorSummaries(Arrays.asList(detectorSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder detectorSummaries(Consumer<DetectorSummary.Builder>... detectorSummaries) {
            detectorSummaries(Stream.of(detectorSummaries).map(c -> DetectorSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDetectorsResponse build() {
            return new ListDetectorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
