/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.ioteventsdata.model.BatchAcknowledgeAlarmRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchAcknowledgeAlarmResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchDeleteDetectorRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchDeleteDetectorResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchDisableAlarmRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchDisableAlarmResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchEnableAlarmRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchEnableAlarmResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchPutMessageRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchPutMessageResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchResetAlarmRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchResetAlarmResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchSnoozeAlarmRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchSnoozeAlarmResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchUpdateDetectorRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchUpdateDetectorResponse;
import software.amazon.awssdk.services.ioteventsdata.model.DescribeAlarmRequest;
import software.amazon.awssdk.services.ioteventsdata.model.DescribeAlarmResponse;
import software.amazon.awssdk.services.ioteventsdata.model.DescribeDetectorRequest;
import software.amazon.awssdk.services.ioteventsdata.model.DescribeDetectorResponse;
import software.amazon.awssdk.services.ioteventsdata.model.ListAlarmsRequest;
import software.amazon.awssdk.services.ioteventsdata.model.ListAlarmsResponse;
import software.amazon.awssdk.services.ioteventsdata.model.ListDetectorsRequest;
import software.amazon.awssdk.services.ioteventsdata.model.ListDetectorsResponse;

/**
 * Service client for accessing AWS IoT Events Data asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * IoT Events monitors your equipment or device fleets for failures or changes in operation, and triggers actions when
 * such events occur. You can use IoT Events Data API commands to send inputs to detectors, list detectors, and view or
 * update a detector's status.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/what-is-iotevents.html">What is IoT Events?</a> in
 * the <i>IoT Events Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IotEventsDataAsyncClient extends AwsClient {
    String SERVICE_NAME = "ioteventsdata";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "data.iotevents";

    /**
     * <p>
     * Acknowledges one or more alarms. The alarms change to the <code>ACKNOWLEDGED</code> state after you acknowledge
     * them.
     * </p>
     *
     * @param batchAcknowledgeAlarmRequest
     * @return A Java Future containing the result of the BatchAcknowledgeAlarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.BatchAcknowledgeAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchAcknowledgeAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAcknowledgeAlarmResponse> batchAcknowledgeAlarm(
            BatchAcknowledgeAlarmRequest batchAcknowledgeAlarmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Acknowledges one or more alarms. The alarms change to the <code>ACKNOWLEDGED</code> state after you acknowledge
     * them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchAcknowledgeAlarmRequest.Builder} avoiding the
     * need to create one manually via {@link BatchAcknowledgeAlarmRequest#builder()}
     * </p>
     *
     * @param batchAcknowledgeAlarmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ioteventsdata.model.BatchAcknowledgeAlarmRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the BatchAcknowledgeAlarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.BatchAcknowledgeAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchAcknowledgeAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAcknowledgeAlarmResponse> batchAcknowledgeAlarm(
            Consumer<BatchAcknowledgeAlarmRequest.Builder> batchAcknowledgeAlarmRequest) {
        return batchAcknowledgeAlarm(BatchAcknowledgeAlarmRequest.builder().applyMutation(batchAcknowledgeAlarmRequest).build());
    }

    /**
     * <p>
     * Deletes one or more detectors that were created. When a detector is deleted, its state will be cleared and the
     * detector will be removed from the list of detectors. The deleted detector will no longer appear if referenced in
     * the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_ListDetectors.html">
     * ListDetectors</a> API call.
     * </p>
     *
     * @param batchDeleteDetectorRequest
     * @return A Java Future containing the result of the BatchDeleteDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.BatchDeleteDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchDeleteDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteDetectorResponse> batchDeleteDetector(
            BatchDeleteDetectorRequest batchDeleteDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more detectors that were created. When a detector is deleted, its state will be cleared and the
     * detector will be removed from the list of detectors. The deleted detector will no longer appear if referenced in
     * the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_ListDetectors.html">
     * ListDetectors</a> API call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteDetectorRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeleteDetectorRequest#builder()}
     * </p>
     *
     * @param batchDeleteDetectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ioteventsdata.model.BatchDeleteDetectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDeleteDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.BatchDeleteDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchDeleteDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteDetectorResponse> batchDeleteDetector(
            Consumer<BatchDeleteDetectorRequest.Builder> batchDeleteDetectorRequest) {
        return batchDeleteDetector(BatchDeleteDetectorRequest.builder().applyMutation(batchDeleteDetectorRequest).build());
    }

    /**
     * <p>
     * Disables one or more alarms. The alarms change to the <code>DISABLED</code> state after you disable them.
     * </p>
     *
     * @param batchDisableAlarmRequest
     * @return A Java Future containing the result of the BatchDisableAlarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.BatchDisableAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchDisableAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisableAlarmResponse> batchDisableAlarm(BatchDisableAlarmRequest batchDisableAlarmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables one or more alarms. The alarms change to the <code>DISABLED</code> state after you disable them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDisableAlarmRequest.Builder} avoiding the need
     * to create one manually via {@link BatchDisableAlarmRequest#builder()}
     * </p>
     *
     * @param batchDisableAlarmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ioteventsdata.model.BatchDisableAlarmRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDisableAlarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.BatchDisableAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchDisableAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisableAlarmResponse> batchDisableAlarm(
            Consumer<BatchDisableAlarmRequest.Builder> batchDisableAlarmRequest) {
        return batchDisableAlarm(BatchDisableAlarmRequest.builder().applyMutation(batchDisableAlarmRequest).build());
    }

    /**
     * <p>
     * Enables one or more alarms. The alarms change to the <code>NORMAL</code> state after you enable them.
     * </p>
     *
     * @param batchEnableAlarmRequest
     * @return A Java Future containing the result of the BatchEnableAlarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.BatchEnableAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchEnableAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchEnableAlarmResponse> batchEnableAlarm(BatchEnableAlarmRequest batchEnableAlarmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables one or more alarms. The alarms change to the <code>NORMAL</code> state after you enable them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchEnableAlarmRequest.Builder} avoiding the need
     * to create one manually via {@link BatchEnableAlarmRequest#builder()}
     * </p>
     *
     * @param batchEnableAlarmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ioteventsdata.model.BatchEnableAlarmRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchEnableAlarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.BatchEnableAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchEnableAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchEnableAlarmResponse> batchEnableAlarm(
            Consumer<BatchEnableAlarmRequest.Builder> batchEnableAlarmRequest) {
        return batchEnableAlarm(BatchEnableAlarmRequest.builder().applyMutation(batchEnableAlarmRequest).build());
    }

    /**
     * <p>
     * Sends a set of messages to the IoT Events system. Each message payload is transformed into the input you specify
     * (<code>"inputName"</code>) and ingested into any detectors that monitor that input. If multiple messages are
     * sent, the order in which the messages are processed isn't guaranteed. To guarantee ordering, you must send
     * messages one at a time and wait for a successful response.
     * </p>
     *
     * @param batchPutMessageRequest
     * @return A Java Future containing the result of the BatchPutMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.BatchPutMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchPutMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchPutMessageResponse> batchPutMessage(BatchPutMessageRequest batchPutMessageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a set of messages to the IoT Events system. Each message payload is transformed into the input you specify
     * (<code>"inputName"</code>) and ingested into any detectors that monitor that input. If multiple messages are
     * sent, the order in which the messages are processed isn't guaranteed. To guarantee ordering, you must send
     * messages one at a time and wait for a successful response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutMessageRequest.Builder} avoiding the need
     * to create one manually via {@link BatchPutMessageRequest#builder()}
     * </p>
     *
     * @param batchPutMessageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ioteventsdata.model.BatchPutMessageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchPutMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.BatchPutMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchPutMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchPutMessageResponse> batchPutMessage(
            Consumer<BatchPutMessageRequest.Builder> batchPutMessageRequest) {
        return batchPutMessage(BatchPutMessageRequest.builder().applyMutation(batchPutMessageRequest).build());
    }

    /**
     * <p>
     * Resets one or more alarms. The alarms return to the <code>NORMAL</code> state after you reset them.
     * </p>
     *
     * @param batchResetAlarmRequest
     * @return A Java Future containing the result of the BatchResetAlarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.BatchResetAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchResetAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchResetAlarmResponse> batchResetAlarm(BatchResetAlarmRequest batchResetAlarmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets one or more alarms. The alarms return to the <code>NORMAL</code> state after you reset them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchResetAlarmRequest.Builder} avoiding the need
     * to create one manually via {@link BatchResetAlarmRequest#builder()}
     * </p>
     *
     * @param batchResetAlarmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ioteventsdata.model.BatchResetAlarmRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchResetAlarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.BatchResetAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchResetAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchResetAlarmResponse> batchResetAlarm(
            Consumer<BatchResetAlarmRequest.Builder> batchResetAlarmRequest) {
        return batchResetAlarm(BatchResetAlarmRequest.builder().applyMutation(batchResetAlarmRequest).build());
    }

    /**
     * <p>
     * Changes one or more alarms to the snooze mode. The alarms change to the <code>SNOOZE_DISABLED</code> state after
     * you set them to the snooze mode.
     * </p>
     *
     * @param batchSnoozeAlarmRequest
     * @return A Java Future containing the result of the BatchSnoozeAlarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.BatchSnoozeAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchSnoozeAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchSnoozeAlarmResponse> batchSnoozeAlarm(BatchSnoozeAlarmRequest batchSnoozeAlarmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes one or more alarms to the snooze mode. The alarms change to the <code>SNOOZE_DISABLED</code> state after
     * you set them to the snooze mode.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchSnoozeAlarmRequest.Builder} avoiding the need
     * to create one manually via {@link BatchSnoozeAlarmRequest#builder()}
     * </p>
     *
     * @param batchSnoozeAlarmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ioteventsdata.model.BatchSnoozeAlarmRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchSnoozeAlarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.BatchSnoozeAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchSnoozeAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchSnoozeAlarmResponse> batchSnoozeAlarm(
            Consumer<BatchSnoozeAlarmRequest.Builder> batchSnoozeAlarmRequest) {
        return batchSnoozeAlarm(BatchSnoozeAlarmRequest.builder().applyMutation(batchSnoozeAlarmRequest).build());
    }

    /**
     * <p>
     * Updates the state, variable values, and timer settings of one or more detectors (instances) of a specified
     * detector model.
     * </p>
     *
     * @param batchUpdateDetectorRequest
     * @return A Java Future containing the result of the BatchUpdateDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.BatchUpdateDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchUpdateDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateDetectorResponse> batchUpdateDetector(
            BatchUpdateDetectorRequest batchUpdateDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the state, variable values, and timer settings of one or more detectors (instances) of a specified
     * detector model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateDetectorRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateDetectorRequest#builder()}
     * </p>
     *
     * @param batchUpdateDetectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ioteventsdata.model.BatchUpdateDetectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchUpdateDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.BatchUpdateDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchUpdateDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateDetectorResponse> batchUpdateDetector(
            Consumer<BatchUpdateDetectorRequest.Builder> batchUpdateDetectorRequest) {
        return batchUpdateDetector(BatchUpdateDetectorRequest.builder().applyMutation(batchUpdateDetectorRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an alarm.
     * </p>
     *
     * @param describeAlarmRequest
     * @return A Java Future containing the result of the DescribeAlarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.DescribeAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/DescribeAlarm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAlarmResponse> describeAlarm(DescribeAlarmRequest describeAlarmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an alarm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAlarmRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAlarmRequest#builder()}
     * </p>
     *
     * @param describeAlarmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ioteventsdata.model.DescribeAlarmRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAlarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.DescribeAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/DescribeAlarm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAlarmResponse> describeAlarm(Consumer<DescribeAlarmRequest.Builder> describeAlarmRequest) {
        return describeAlarm(DescribeAlarmRequest.builder().applyMutation(describeAlarmRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified detector (instance).
     * </p>
     *
     * @param describeDetectorRequest
     * @return A Java Future containing the result of the DescribeDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.DescribeDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/DescribeDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDetectorResponse> describeDetector(DescribeDetectorRequest describeDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified detector (instance).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDetectorRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDetectorRequest#builder()}
     * </p>
     *
     * @param describeDetectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ioteventsdata.model.DescribeDetectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.DescribeDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/DescribeDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDetectorResponse> describeDetector(
            Consumer<DescribeDetectorRequest.Builder> describeDetectorRequest) {
        return describeDetector(DescribeDetectorRequest.builder().applyMutation(describeDetectorRequest).build());
    }

    /**
     * <p>
     * Lists one or more alarms. The operation returns only the metadata associated with each alarm.
     * </p>
     *
     * @param listAlarmsRequest
     * @return A Java Future containing the result of the ListAlarms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.ListAlarms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/ListAlarms" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAlarmsResponse> listAlarms(ListAlarmsRequest listAlarmsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists one or more alarms. The operation returns only the metadata associated with each alarm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAlarmsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAlarmsRequest#builder()}
     * </p>
     *
     * @param listAlarmsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ioteventsdata.model.ListAlarmsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAlarms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.ListAlarms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/ListAlarms" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAlarmsResponse> listAlarms(Consumer<ListAlarmsRequest.Builder> listAlarmsRequest) {
        return listAlarms(ListAlarmsRequest.builder().applyMutation(listAlarmsRequest).build());
    }

    /**
     * <p>
     * Lists detectors (the instances of a detector model).
     * </p>
     *
     * @param listDetectorsRequest
     * @return A Java Future containing the result of the ListDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.ListDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/ListDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDetectorsResponse> listDetectors(ListDetectorsRequest listDetectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists detectors (the instances of a detector model).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDetectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDetectorsRequest#builder()}
     * </p>
     *
     * @param listDetectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ioteventsdata.model.ListDetectorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request was invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ThrottlingException The request could not be completed due to throttling.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotEventsDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotEventsDataAsyncClient.ListDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/ListDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDetectorsResponse> listDetectors(Consumer<ListDetectorsRequest.Builder> listDetectorsRequest) {
        return listDetectors(ListDetectorsRequest.builder().applyMutation(listDetectorsRequest).build());
    }

    @Override
    default IotEventsDataServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link IotEventsDataAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IotEventsDataAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IotEventsDataAsyncClient}.
     */
    static IotEventsDataAsyncClientBuilder builder() {
        return new DefaultIotEventsDataAsyncClientBuilder();
    }
}
