/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ioteventsdata.model.BatchAcknowledgeAlarmRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchAcknowledgeAlarmResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchDeleteDetectorRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchDeleteDetectorResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchDisableAlarmRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchDisableAlarmResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchEnableAlarmRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchEnableAlarmResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchPutMessageRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchPutMessageResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchResetAlarmRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchResetAlarmResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchSnoozeAlarmRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchSnoozeAlarmResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchUpdateDetectorRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchUpdateDetectorResponse;
import software.amazon.awssdk.services.ioteventsdata.model.DescribeAlarmRequest;
import software.amazon.awssdk.services.ioteventsdata.model.DescribeAlarmResponse;
import software.amazon.awssdk.services.ioteventsdata.model.DescribeDetectorRequest;
import software.amazon.awssdk.services.ioteventsdata.model.DescribeDetectorResponse;
import software.amazon.awssdk.services.ioteventsdata.model.InternalFailureException;
import software.amazon.awssdk.services.ioteventsdata.model.InvalidRequestException;
import software.amazon.awssdk.services.ioteventsdata.model.IotEventsDataException;
import software.amazon.awssdk.services.ioteventsdata.model.ListAlarmsRequest;
import software.amazon.awssdk.services.ioteventsdata.model.ListAlarmsResponse;
import software.amazon.awssdk.services.ioteventsdata.model.ListDetectorsRequest;
import software.amazon.awssdk.services.ioteventsdata.model.ListDetectorsResponse;
import software.amazon.awssdk.services.ioteventsdata.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ioteventsdata.model.ServiceUnavailableException;
import software.amazon.awssdk.services.ioteventsdata.model.ThrottlingException;

/**
 * Service client for accessing AWS IoT Events Data. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * IoT Events monitors your equipment or device fleets for failures or changes in operation, and triggers actions when
 * such events occur. You can use IoT Events Data API commands to send inputs to detectors, list detectors, and view or
 * update a detector's status.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/what-is-iotevents.html">What is IoT Events?</a> in
 * the <i>IoT Events Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IotEventsDataClient extends AwsClient {
    String SERVICE_NAME = "ioteventsdata";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "data.iotevents";

    /**
     * <p>
     * Acknowledges one or more alarms. The alarms change to the <code>ACKNOWLEDGED</code> state after you acknowledge
     * them.
     * </p>
     *
     * @param batchAcknowledgeAlarmRequest
     * @return Result of the BatchAcknowledgeAlarm operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchAcknowledgeAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchAcknowledgeAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchAcknowledgeAlarmResponse batchAcknowledgeAlarm(BatchAcknowledgeAlarmRequest batchAcknowledgeAlarmRequest)
            throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Acknowledges one or more alarms. The alarms change to the <code>ACKNOWLEDGED</code> state after you acknowledge
     * them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchAcknowledgeAlarmRequest.Builder} avoiding the
     * need to create one manually via {@link BatchAcknowledgeAlarmRequest#builder()}
     * </p>
     *
     * @param batchAcknowledgeAlarmRequest
     *        A {@link Consumer} that will call methods on {@link BatchAcknowledgeAlarmRequest.Builder} to create a
     *        request.
     * @return Result of the BatchAcknowledgeAlarm operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchAcknowledgeAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchAcknowledgeAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchAcknowledgeAlarmResponse batchAcknowledgeAlarm(
            Consumer<BatchAcknowledgeAlarmRequest.Builder> batchAcknowledgeAlarmRequest) throws InvalidRequestException,
            InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotEventsDataException {
        return batchAcknowledgeAlarm(BatchAcknowledgeAlarmRequest.builder().applyMutation(batchAcknowledgeAlarmRequest).build());
    }

    /**
     * <p>
     * Deletes one or more detectors that were created. When a detector is deleted, its state will be cleared and the
     * detector will be removed from the list of detectors. The deleted detector will no longer appear if referenced in
     * the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_ListDetectors.html">
     * ListDetectors</a> API call.
     * </p>
     *
     * @param batchDeleteDetectorRequest
     * @return Result of the BatchDeleteDetector operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchDeleteDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchDeleteDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteDetectorResponse batchDeleteDetector(BatchDeleteDetectorRequest batchDeleteDetectorRequest)
            throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more detectors that were created. When a detector is deleted, its state will be cleared and the
     * detector will be removed from the list of detectors. The deleted detector will no longer appear if referenced in
     * the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_ListDetectors.html">
     * ListDetectors</a> API call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteDetectorRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeleteDetectorRequest#builder()}
     * </p>
     *
     * @param batchDeleteDetectorRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteDetectorRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDeleteDetector operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchDeleteDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchDeleteDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteDetectorResponse batchDeleteDetector(
            Consumer<BatchDeleteDetectorRequest.Builder> batchDeleteDetectorRequest) throws InvalidRequestException,
            InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotEventsDataException {
        return batchDeleteDetector(BatchDeleteDetectorRequest.builder().applyMutation(batchDeleteDetectorRequest).build());
    }

    /**
     * <p>
     * Disables one or more alarms. The alarms change to the <code>DISABLED</code> state after you disable them.
     * </p>
     *
     * @param batchDisableAlarmRequest
     * @return Result of the BatchDisableAlarm operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchDisableAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchDisableAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisableAlarmResponse batchDisableAlarm(BatchDisableAlarmRequest batchDisableAlarmRequest)
            throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables one or more alarms. The alarms change to the <code>DISABLED</code> state after you disable them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDisableAlarmRequest.Builder} avoiding the need
     * to create one manually via {@link BatchDisableAlarmRequest#builder()}
     * </p>
     *
     * @param batchDisableAlarmRequest
     *        A {@link Consumer} that will call methods on {@link BatchDisableAlarmRequest.Builder} to create a request.
     * @return Result of the BatchDisableAlarm operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchDisableAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchDisableAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisableAlarmResponse batchDisableAlarm(Consumer<BatchDisableAlarmRequest.Builder> batchDisableAlarmRequest)
            throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        return batchDisableAlarm(BatchDisableAlarmRequest.builder().applyMutation(batchDisableAlarmRequest).build());
    }

    /**
     * <p>
     * Enables one or more alarms. The alarms change to the <code>NORMAL</code> state after you enable them.
     * </p>
     *
     * @param batchEnableAlarmRequest
     * @return Result of the BatchEnableAlarm operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchEnableAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchEnableAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchEnableAlarmResponse batchEnableAlarm(BatchEnableAlarmRequest batchEnableAlarmRequest)
            throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables one or more alarms. The alarms change to the <code>NORMAL</code> state after you enable them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchEnableAlarmRequest.Builder} avoiding the need
     * to create one manually via {@link BatchEnableAlarmRequest#builder()}
     * </p>
     *
     * @param batchEnableAlarmRequest
     *        A {@link Consumer} that will call methods on {@link BatchEnableAlarmRequest.Builder} to create a request.
     * @return Result of the BatchEnableAlarm operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchEnableAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchEnableAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchEnableAlarmResponse batchEnableAlarm(Consumer<BatchEnableAlarmRequest.Builder> batchEnableAlarmRequest)
            throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        return batchEnableAlarm(BatchEnableAlarmRequest.builder().applyMutation(batchEnableAlarmRequest).build());
    }

    /**
     * <p>
     * Sends a set of messages to the IoT Events system. Each message payload is transformed into the input you specify
     * (<code>"inputName"</code>) and ingested into any detectors that monitor that input. If multiple messages are
     * sent, the order in which the messages are processed isn't guaranteed. To guarantee ordering, you must send
     * messages one at a time and wait for a successful response.
     * </p>
     *
     * @param batchPutMessageRequest
     * @return Result of the BatchPutMessage operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchPutMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchPutMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchPutMessageResponse batchPutMessage(BatchPutMessageRequest batchPutMessageRequest)
            throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a set of messages to the IoT Events system. Each message payload is transformed into the input you specify
     * (<code>"inputName"</code>) and ingested into any detectors that monitor that input. If multiple messages are
     * sent, the order in which the messages are processed isn't guaranteed. To guarantee ordering, you must send
     * messages one at a time and wait for a successful response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutMessageRequest.Builder} avoiding the need
     * to create one manually via {@link BatchPutMessageRequest#builder()}
     * </p>
     *
     * @param batchPutMessageRequest
     *        A {@link Consumer} that will call methods on {@link BatchPutMessageRequest.Builder} to create a request.
     * @return Result of the BatchPutMessage operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchPutMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchPutMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchPutMessageResponse batchPutMessage(Consumer<BatchPutMessageRequest.Builder> batchPutMessageRequest)
            throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        return batchPutMessage(BatchPutMessageRequest.builder().applyMutation(batchPutMessageRequest).build());
    }

    /**
     * <p>
     * Resets one or more alarms. The alarms return to the <code>NORMAL</code> state after you reset them.
     * </p>
     *
     * @param batchResetAlarmRequest
     * @return Result of the BatchResetAlarm operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchResetAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchResetAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchResetAlarmResponse batchResetAlarm(BatchResetAlarmRequest batchResetAlarmRequest)
            throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets one or more alarms. The alarms return to the <code>NORMAL</code> state after you reset them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchResetAlarmRequest.Builder} avoiding the need
     * to create one manually via {@link BatchResetAlarmRequest#builder()}
     * </p>
     *
     * @param batchResetAlarmRequest
     *        A {@link Consumer} that will call methods on {@link BatchResetAlarmRequest.Builder} to create a request.
     * @return Result of the BatchResetAlarm operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchResetAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchResetAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchResetAlarmResponse batchResetAlarm(Consumer<BatchResetAlarmRequest.Builder> batchResetAlarmRequest)
            throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        return batchResetAlarm(BatchResetAlarmRequest.builder().applyMutation(batchResetAlarmRequest).build());
    }

    /**
     * <p>
     * Changes one or more alarms to the snooze mode. The alarms change to the <code>SNOOZE_DISABLED</code> state after
     * you set them to the snooze mode.
     * </p>
     *
     * @param batchSnoozeAlarmRequest
     * @return Result of the BatchSnoozeAlarm operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchSnoozeAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchSnoozeAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchSnoozeAlarmResponse batchSnoozeAlarm(BatchSnoozeAlarmRequest batchSnoozeAlarmRequest)
            throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes one or more alarms to the snooze mode. The alarms change to the <code>SNOOZE_DISABLED</code> state after
     * you set them to the snooze mode.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchSnoozeAlarmRequest.Builder} avoiding the need
     * to create one manually via {@link BatchSnoozeAlarmRequest#builder()}
     * </p>
     *
     * @param batchSnoozeAlarmRequest
     *        A {@link Consumer} that will call methods on {@link BatchSnoozeAlarmRequest.Builder} to create a request.
     * @return Result of the BatchSnoozeAlarm operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchSnoozeAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchSnoozeAlarm"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchSnoozeAlarmResponse batchSnoozeAlarm(Consumer<BatchSnoozeAlarmRequest.Builder> batchSnoozeAlarmRequest)
            throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        return batchSnoozeAlarm(BatchSnoozeAlarmRequest.builder().applyMutation(batchSnoozeAlarmRequest).build());
    }

    /**
     * <p>
     * Updates the state, variable values, and timer settings of one or more detectors (instances) of a specified
     * detector model.
     * </p>
     *
     * @param batchUpdateDetectorRequest
     * @return Result of the BatchUpdateDetector operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchUpdateDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchUpdateDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateDetectorResponse batchUpdateDetector(BatchUpdateDetectorRequest batchUpdateDetectorRequest)
            throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the state, variable values, and timer settings of one or more detectors (instances) of a specified
     * detector model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateDetectorRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateDetectorRequest#builder()}
     * </p>
     *
     * @param batchUpdateDetectorRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpdateDetectorRequest.Builder} to create a
     *        request.
     * @return Result of the BatchUpdateDetector operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.BatchUpdateDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchUpdateDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateDetectorResponse batchUpdateDetector(
            Consumer<BatchUpdateDetectorRequest.Builder> batchUpdateDetectorRequest) throws InvalidRequestException,
            InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotEventsDataException {
        return batchUpdateDetector(BatchUpdateDetectorRequest.builder().applyMutation(batchUpdateDetectorRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an alarm.
     * </p>
     *
     * @param describeAlarmRequest
     * @return Result of the DescribeAlarm operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.DescribeAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/DescribeAlarm" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAlarmResponse describeAlarm(DescribeAlarmRequest describeAlarmRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an alarm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAlarmRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAlarmRequest#builder()}
     * </p>
     *
     * @param describeAlarmRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAlarmRequest.Builder} to create a request.
     * @return Result of the DescribeAlarm operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.DescribeAlarm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/DescribeAlarm" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAlarmResponse describeAlarm(Consumer<DescribeAlarmRequest.Builder> describeAlarmRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsDataException {
        return describeAlarm(DescribeAlarmRequest.builder().applyMutation(describeAlarmRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified detector (instance).
     * </p>
     *
     * @param describeDetectorRequest
     * @return Result of the DescribeDetector operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.DescribeDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/DescribeDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDetectorResponse describeDetector(DescribeDetectorRequest describeDetectorRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified detector (instance).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDetectorRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDetectorRequest#builder()}
     * </p>
     *
     * @param describeDetectorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDetectorRequest.Builder} to create a request.
     * @return Result of the DescribeDetector operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.DescribeDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/DescribeDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDetectorResponse describeDetector(Consumer<DescribeDetectorRequest.Builder> describeDetectorRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsDataException {
        return describeDetector(DescribeDetectorRequest.builder().applyMutation(describeDetectorRequest).build());
    }

    /**
     * <p>
     * Lists one or more alarms. The operation returns only the metadata associated with each alarm.
     * </p>
     *
     * @param listAlarmsRequest
     * @return Result of the ListAlarms operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.ListAlarms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/ListAlarms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlarmsResponse listAlarms(ListAlarmsRequest listAlarmsRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists one or more alarms. The operation returns only the metadata associated with each alarm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAlarmsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAlarmsRequest#builder()}
     * </p>
     *
     * @param listAlarmsRequest
     *        A {@link Consumer} that will call methods on {@link ListAlarmsRequest.Builder} to create a request.
     * @return Result of the ListAlarms operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.ListAlarms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/ListAlarms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlarmsResponse listAlarms(Consumer<ListAlarmsRequest.Builder> listAlarmsRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        return listAlarms(ListAlarmsRequest.builder().applyMutation(listAlarmsRequest).build());
    }

    /**
     * <p>
     * Lists detectors (the instances of a detector model).
     * </p>
     *
     * @param listDetectorsRequest
     * @return Result of the ListDetectors operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.ListDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/ListDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDetectorsResponse listDetectors(ListDetectorsRequest listDetectorsRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotEventsDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists detectors (the instances of a detector model).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDetectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDetectorsRequest#builder()}
     * </p>
     *
     * @param listDetectorsRequest
     *        A {@link Consumer} that will call methods on {@link ListDetectorsRequest.Builder} to create a request.
     * @return Result of the ListDetectors operation returned by the service.
     * @throws InvalidRequestException
     *         The request was invalid.
     * @throws ResourceNotFoundException
     *         The resource was not found.
     * @throws ThrottlingException
     *         The request could not be completed due to throttling.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ServiceUnavailableException
     *         The service is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotEventsDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotEventsDataClient.ListDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/ListDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDetectorsResponse listDetectors(Consumer<ListDetectorsRequest.Builder> listDetectorsRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsDataException {
        return listDetectors(ListDetectorsRequest.builder().applyMutation(listDetectorsRequest).build());
    }

    /**
     * Create a {@link IotEventsDataClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IotEventsDataClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IotEventsDataClient}.
     */
    static IotEventsDataClientBuilder builder() {
        return new DefaultIotEventsDataClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default IotEventsDataServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
