/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a timestamp.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimestampValue implements SdkPojo, Serializable, ToCopyableBuilder<TimestampValue.Builder, TimestampValue> {
    private static final SdkField<Long> TIME_IN_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("timeInMillis").getter(getter(TimestampValue::timeInMillis)).setter(setter(Builder::timeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeInMillis").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_IN_MILLIS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long timeInMillis;

    private TimestampValue(BuilderImpl builder) {
        this.timeInMillis = builder.timeInMillis;
    }

    /**
     * <p>
     * The value of the timestamp, in the Unix epoch format.
     * </p>
     * 
     * @return The value of the timestamp, in the Unix epoch format.
     */
    public final Long timeInMillis() {
        return timeInMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeInMillis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestampValue)) {
            return false;
        }
        TimestampValue other = (TimestampValue) obj;
        return Objects.equals(timeInMillis(), other.timeInMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimestampValue").add("TimeInMillis", timeInMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeInMillis":
            return Optional.ofNullable(clazz.cast(timeInMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimestampValue, T> g) {
        return obj -> g.apply((TimestampValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimestampValue> {
        /**
         * <p>
         * The value of the timestamp, in the Unix epoch format.
         * </p>
         * 
         * @param timeInMillis
         *        The value of the timestamp, in the Unix epoch format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeInMillis(Long timeInMillis);
    }

    static final class BuilderImpl implements Builder {
        private Long timeInMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(TimestampValue model) {
            timeInMillis(model.timeInMillis);
        }

        public final Long getTimeInMillis() {
            return timeInMillis;
        }

        public final void setTimeInMillis(Long timeInMillis) {
            this.timeInMillis = timeInMillis;
        }

        @Override
        public final Builder timeInMillis(Long timeInMillis) {
            this.timeInMillis = timeInMillis;
            return this;
        }

        @Override
        public TimestampValue build() {
            return new TimestampValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
