/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class BatchDeleteDetectorErrorEntriesCopier {
    static List<BatchDeleteDetectorErrorEntry> copy(
            Collection<? extends BatchDeleteDetectorErrorEntry> batchDeleteDetectorErrorEntriesParam) {
        List<BatchDeleteDetectorErrorEntry> list;
        if (batchDeleteDetectorErrorEntriesParam == null || batchDeleteDetectorErrorEntriesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchDeleteDetectorErrorEntry> modifiableList = new ArrayList<>(batchDeleteDetectorErrorEntriesParam.size());
            batchDeleteDetectorErrorEntriesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BatchDeleteDetectorErrorEntry> copyFromBuilder(
            Collection<? extends BatchDeleteDetectorErrorEntry.Builder> batchDeleteDetectorErrorEntriesParam) {
        List<BatchDeleteDetectorErrorEntry> list;
        if (batchDeleteDetectorErrorEntriesParam == null || batchDeleteDetectorErrorEntriesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchDeleteDetectorErrorEntry> modifiableList = new ArrayList<>(batchDeleteDetectorErrorEntriesParam.size());
            batchDeleteDetectorErrorEntriesParam.forEach(entry -> {
                BatchDeleteDetectorErrorEntry member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BatchDeleteDetectorErrorEntry.Builder> copyToBuilder(
            Collection<? extends BatchDeleteDetectorErrorEntry> batchDeleteDetectorErrorEntriesParam) {
        List<BatchDeleteDetectorErrorEntry.Builder> list;
        if (batchDeleteDetectorErrorEntriesParam == null || batchDeleteDetectorErrorEntriesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchDeleteDetectorErrorEntry.Builder> modifiableList = new ArrayList<>(
                    batchDeleteDetectorErrorEntriesParam.size());
            batchDeleteDetectorErrorEntriesParam.forEach(entry -> {
                BatchDeleteDetectorErrorEntry.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
