/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ioteventsdata.model.DeleteDetectorRequest;
import software.amazon.awssdk.services.ioteventsdata.model.DeleteDetectorRequestsCopier;
import software.amazon.awssdk.services.ioteventsdata.model.IotEventsDataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteDetectorRequest
extends IotEventsDataRequest
implements ToCopyableBuilder<Builder, BatchDeleteDetectorRequest> {
    private static final SdkField<List<DeleteDetectorRequest>> DETECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("detectors").getter(BatchDeleteDetectorRequest.getter(BatchDeleteDetectorRequest::detectors)).setter(BatchDeleteDetectorRequest.setter(Builder::detectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeleteDetectorRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteDetectorRequest.memberNameToFieldInitializer();
    private final List<DeleteDetectorRequest> detectors;

    private BatchDeleteDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.detectors = builder.detectors;
    }

    public final boolean hasDetectors() {
        return this.detectors != null && !(this.detectors instanceof SdkAutoConstructList);
    }

    public final List<DeleteDetectorRequest> detectors() {
        return this.detectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetectors() ? this.detectors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteDetectorRequest)) {
            return false;
        }
        BatchDeleteDetectorRequest other = (BatchDeleteDetectorRequest)((Object)obj);
        return this.hasDetectors() == other.hasDetectors() && Objects.equals(this.detectors(), other.detectors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteDetectorRequest").add("Detectors", this.hasDetectors() ? this.detectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectors": {
                return Optional.ofNullable(clazz.cast(this.detectors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<DeleteDetectorRequest>>> map = new HashMap<String, SdkField<List<DeleteDetectorRequest>>>();
        map.put("detectors", DETECTORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteDetectorRequest, T> g) {
        return obj -> g.apply((BatchDeleteDetectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsDataRequest.BuilderImpl
    implements Builder {
        private List<DeleteDetectorRequest> detectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteDetectorRequest model) {
            super(model);
            this.detectors(model.detectors);
        }

        public final List<DeleteDetectorRequest.Builder> getDetectors() {
            List<DeleteDetectorRequest.Builder> result = DeleteDetectorRequestsCopier.copyToBuilder(this.detectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetectors(Collection<DeleteDetectorRequest.BuilderImpl> detectors) {
            this.detectors = DeleteDetectorRequestsCopier.copyFromBuilder(detectors);
        }

        @Override
        public final Builder detectors(Collection<DeleteDetectorRequest> detectors) {
            this.detectors = DeleteDetectorRequestsCopier.copy(detectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectors(DeleteDetectorRequest ... detectors) {
            this.detectors(Arrays.asList(detectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectors(Consumer<DeleteDetectorRequest.Builder> ... detectors) {
            this.detectors(Stream.of(detectors).map(c -> (DeleteDetectorRequest)((DeleteDetectorRequest.Builder)DeleteDetectorRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteDetectorRequest build() {
            return new BatchDeleteDetectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotEventsDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteDetectorRequest> {
        public Builder detectors(Collection<DeleteDetectorRequest> var1);

        public Builder detectors(DeleteDetectorRequest ... var1);

        public Builder detectors(Consumer<DeleteDetectorRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

