/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an alarm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Alarm implements SdkPojo, Serializable, ToCopyableBuilder<Alarm.Builder, Alarm> {
    private static final SdkField<String> ALARM_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelName").getter(getter(Alarm::alarmModelName)).setter(setter(Builder::alarmModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelName").build()).build();

    private static final SdkField<String> ALARM_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelVersion").getter(getter(Alarm::alarmModelVersion)).setter(setter(Builder::alarmModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelVersion").build()).build();

    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyValue").getter(getter(Alarm::keyValue)).setter(setter(Builder::keyValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyValue").build()).build();

    private static final SdkField<AlarmState> ALARM_STATE_FIELD = SdkField.<AlarmState> builder(MarshallingType.SDK_POJO)
            .memberName("alarmState").getter(getter(Alarm::alarmState)).setter(setter(Builder::alarmState))
            .constructor(AlarmState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmState").build()).build();

    private static final SdkField<Integer> SEVERITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("severity").getter(getter(Alarm::severity)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(Alarm::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(Alarm::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_MODEL_NAME_FIELD,
            ALARM_MODEL_VERSION_FIELD, KEY_VALUE_FIELD, ALARM_STATE_FIELD, SEVERITY_FIELD, CREATION_TIME_FIELD,
            LAST_UPDATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String alarmModelName;

    private final String alarmModelVersion;

    private final String keyValue;

    private final AlarmState alarmState;

    private final Integer severity;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private Alarm(BuilderImpl builder) {
        this.alarmModelName = builder.alarmModelName;
        this.alarmModelVersion = builder.alarmModelVersion;
        this.keyValue = builder.keyValue;
        this.alarmState = builder.alarmState;
        this.severity = builder.severity;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The name of the alarm model.
     * </p>
     * 
     * @return The name of the alarm model.
     */
    public final String alarmModelName() {
        return alarmModelName;
    }

    /**
     * <p>
     * The version of the alarm model.
     * </p>
     * 
     * @return The version of the alarm model.
     */
    public final String alarmModelVersion() {
        return alarmModelVersion;
    }

    /**
     * <p>
     * The value of the key used as a filter to select only the alarms associated with the <a href=
     * "https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key"
     * >key</a>.
     * </p>
     * 
     * @return The value of the key used as a filter to select only the alarms associated with the <a href=
     *         "https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key"
     *         >key</a>.
     */
    public final String keyValue() {
        return keyValue;
    }

    /**
     * <p>
     * Contains information about the current state of the alarm.
     * </p>
     * 
     * @return Contains information about the current state of the alarm.
     */
    public final AlarmState alarmState() {
        return alarmState;
    }

    /**
     * <p>
     * A non-negative integer that reflects the severity level of the alarm.
     * </p>
     * 
     * @return A non-negative integer that reflects the severity level of the alarm.
     */
    public final Integer severity() {
        return severity;
    }

    /**
     * <p>
     * The time the alarm was created, in the Unix epoch format.
     * </p>
     * 
     * @return The time the alarm was created, in the Unix epoch format.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the alarm was last updated, in the Unix epoch format.
     * </p>
     * 
     * @return The time the alarm was last updated, in the Unix epoch format.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelName());
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(keyValue());
        hashCode = 31 * hashCode + Objects.hashCode(alarmState());
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alarm)) {
            return false;
        }
        Alarm other = (Alarm) obj;
        return Objects.equals(alarmModelName(), other.alarmModelName())
                && Objects.equals(alarmModelVersion(), other.alarmModelVersion()) && Objects.equals(keyValue(), other.keyValue())
                && Objects.equals(alarmState(), other.alarmState()) && Objects.equals(severity(), other.severity())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Alarm").add("AlarmModelName", alarmModelName()).add("AlarmModelVersion", alarmModelVersion())
                .add("KeyValue", keyValue()).add("AlarmState", alarmState()).add("Severity", severity())
                .add("CreationTime", creationTime()).add("LastUpdateTime", lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alarmModelName":
            return Optional.ofNullable(clazz.cast(alarmModelName()));
        case "alarmModelVersion":
            return Optional.ofNullable(clazz.cast(alarmModelVersion()));
        case "keyValue":
            return Optional.ofNullable(clazz.cast(keyValue()));
        case "alarmState":
            return Optional.ofNullable(clazz.cast(alarmState()));
        case "severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("alarmModelName", ALARM_MODEL_NAME_FIELD);
        map.put("alarmModelVersion", ALARM_MODEL_VERSION_FIELD);
        map.put("keyValue", KEY_VALUE_FIELD);
        map.put("alarmState", ALARM_STATE_FIELD);
        map.put("severity", SEVERITY_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdateTime", LAST_UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Alarm, T> g) {
        return obj -> g.apply((Alarm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Alarm> {
        /**
         * <p>
         * The name of the alarm model.
         * </p>
         * 
         * @param alarmModelName
         *        The name of the alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelName(String alarmModelName);

        /**
         * <p>
         * The version of the alarm model.
         * </p>
         * 
         * @param alarmModelVersion
         *        The version of the alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelVersion(String alarmModelVersion);

        /**
         * <p>
         * The value of the key used as a filter to select only the alarms associated with the <a href=
         * "https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key"
         * >key</a>.
         * </p>
         * 
         * @param keyValue
         *        The value of the key used as a filter to select only the alarms associated with the <a href=
         *        "https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key"
         *        >key</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyValue(String keyValue);

        /**
         * <p>
         * Contains information about the current state of the alarm.
         * </p>
         * 
         * @param alarmState
         *        Contains information about the current state of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmState(AlarmState alarmState);

        /**
         * <p>
         * Contains information about the current state of the alarm.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlarmState.Builder} avoiding the need to
         * create one manually via {@link AlarmState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlarmState.Builder#build()} is called immediately and its result
         * is passed to {@link #alarmState(AlarmState)}.
         * 
         * @param alarmState
         *        a consumer that will call methods on {@link AlarmState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmState(AlarmState)
         */
        default Builder alarmState(Consumer<AlarmState.Builder> alarmState) {
            return alarmState(AlarmState.builder().applyMutation(alarmState).build());
        }

        /**
         * <p>
         * A non-negative integer that reflects the severity level of the alarm.
         * </p>
         * 
         * @param severity
         *        A non-negative integer that reflects the severity level of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(Integer severity);

        /**
         * <p>
         * The time the alarm was created, in the Unix epoch format.
         * </p>
         * 
         * @param creationTime
         *        The time the alarm was created, in the Unix epoch format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the alarm was last updated, in the Unix epoch format.
         * </p>
         * 
         * @param lastUpdateTime
         *        The time the alarm was last updated, in the Unix epoch format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String alarmModelName;

        private String alarmModelVersion;

        private String keyValue;

        private AlarmState alarmState;

        private Integer severity;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Alarm model) {
            alarmModelName(model.alarmModelName);
            alarmModelVersion(model.alarmModelVersion);
            keyValue(model.keyValue);
            alarmState(model.alarmState);
            severity(model.severity);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getAlarmModelName() {
            return alarmModelName;
        }

        public final void setAlarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
        }

        @Override
        public final Builder alarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        public final String getAlarmModelVersion() {
            return alarmModelVersion;
        }

        public final void setAlarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
        }

        @Override
        public final Builder alarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
            return this;
        }

        public final String getKeyValue() {
            return keyValue;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public final AlarmState.Builder getAlarmState() {
            return alarmState != null ? alarmState.toBuilder() : null;
        }

        public final void setAlarmState(AlarmState.BuilderImpl alarmState) {
            this.alarmState = alarmState != null ? alarmState.build() : null;
        }

        @Override
        public final Builder alarmState(AlarmState alarmState) {
            this.alarmState = alarmState;
            return this;
        }

        public final Integer getSeverity() {
            return severity;
        }

        public final void setSeverity(Integer severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(Integer severity) {
            this.severity = severity;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Override
        public Alarm build() {
            return new Alarm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
