/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the current state of the alarm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlarmState implements SdkPojo, Serializable, ToCopyableBuilder<AlarmState.Builder, AlarmState> {
    private static final SdkField<String> STATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateName").getter(getter(AlarmState::stateNameAsString)).setter(setter(Builder::stateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateName").build()).build();

    private static final SdkField<RuleEvaluation> RULE_EVALUATION_FIELD = SdkField
            .<RuleEvaluation> builder(MarshallingType.SDK_POJO).memberName("ruleEvaluation")
            .getter(getter(AlarmState::ruleEvaluation)).setter(setter(Builder::ruleEvaluation))
            .constructor(RuleEvaluation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleEvaluation").build()).build();

    private static final SdkField<CustomerAction> CUSTOMER_ACTION_FIELD = SdkField
            .<CustomerAction> builder(MarshallingType.SDK_POJO).memberName("customerAction")
            .getter(getter(AlarmState::customerAction)).setter(setter(Builder::customerAction))
            .constructor(CustomerAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerAction").build()).build();

    private static final SdkField<SystemEvent> SYSTEM_EVENT_FIELD = SdkField.<SystemEvent> builder(MarshallingType.SDK_POJO)
            .memberName("systemEvent").getter(getter(AlarmState::systemEvent)).setter(setter(Builder::systemEvent))
            .constructor(SystemEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemEvent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_NAME_FIELD,
            RULE_EVALUATION_FIELD, CUSTOMER_ACTION_FIELD, SYSTEM_EVENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stateName;

    private final RuleEvaluation ruleEvaluation;

    private final CustomerAction customerAction;

    private final SystemEvent systemEvent;

    private AlarmState(BuilderImpl builder) {
        this.stateName = builder.stateName;
        this.ruleEvaluation = builder.ruleEvaluation;
        this.customerAction = builder.customerAction;
        this.systemEvent = builder.systemEvent;
    }

    /**
     * <p>
     * The name of the alarm state. The state name can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state, it isn't ready to evaluate data. To
     * enable the alarm, you must change the alarm to the <code>NORMAL</code> state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state, it's ready to evaluate data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state, the alarm is invoked.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state, the alarm was invoked and
     * you acknowledged the alarm.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state, the alarm is disabled
     * for a specified period of time. After the snooze time, the alarm automatically changes to the <code>NORMAL</code>
     * state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state, the alarm was invoked. However, the
     * data that the alarm is currently evaluating is within the specified range. To change the alarm to the
     * <code>NORMAL</code> state, you must acknowledge the alarm.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateName} will
     * return {@link AlarmStateName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateNameAsString}.
     * </p>
     * 
     * @return The name of the alarm state. The state name can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state, it isn't ready to evaluate
     *         data. To enable the alarm, you must change the alarm to the <code>NORMAL</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state, it's ready to evaluate data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state, the alarm is invoked.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state, the alarm was
     *         invoked and you acknowledged the alarm.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state, the alarm is
     *         disabled for a specified period of time. After the snooze time, the alarm automatically changes to the
     *         <code>NORMAL</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state, the alarm was invoked.
     *         However, the data that the alarm is currently evaluating is within the specified range. To change the
     *         alarm to the <code>NORMAL</code> state, you must acknowledge the alarm.
     *         </p>
     *         </li>
     * @see AlarmStateName
     */
    public final AlarmStateName stateName() {
        return AlarmStateName.fromValue(stateName);
    }

    /**
     * <p>
     * The name of the alarm state. The state name can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state, it isn't ready to evaluate data. To
     * enable the alarm, you must change the alarm to the <code>NORMAL</code> state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state, it's ready to evaluate data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state, the alarm is invoked.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state, the alarm was invoked and
     * you acknowledged the alarm.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state, the alarm is disabled
     * for a specified period of time. After the snooze time, the alarm automatically changes to the <code>NORMAL</code>
     * state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state, the alarm was invoked. However, the
     * data that the alarm is currently evaluating is within the specified range. To change the alarm to the
     * <code>NORMAL</code> state, you must acknowledge the alarm.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateName} will
     * return {@link AlarmStateName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateNameAsString}.
     * </p>
     * 
     * @return The name of the alarm state. The state name can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state, it isn't ready to evaluate
     *         data. To enable the alarm, you must change the alarm to the <code>NORMAL</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state, it's ready to evaluate data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state, the alarm is invoked.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state, the alarm was
     *         invoked and you acknowledged the alarm.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state, the alarm is
     *         disabled for a specified period of time. After the snooze time, the alarm automatically changes to the
     *         <code>NORMAL</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state, the alarm was invoked.
     *         However, the data that the alarm is currently evaluating is within the specified range. To change the
     *         alarm to the <code>NORMAL</code> state, you must acknowledge the alarm.
     *         </p>
     *         </li>
     * @see AlarmStateName
     */
    public final String stateNameAsString() {
        return stateName;
    }

    /**
     * <p>
     * Information needed to evaluate data.
     * </p>
     * 
     * @return Information needed to evaluate data.
     */
    public final RuleEvaluation ruleEvaluation() {
        return ruleEvaluation;
    }

    /**
     * <p>
     * Contains information about the action that you can take to respond to the alarm.
     * </p>
     * 
     * @return Contains information about the action that you can take to respond to the alarm.
     */
    public final CustomerAction customerAction() {
        return customerAction;
    }

    /**
     * <p>
     * Contains information about alarm state changes.
     * </p>
     * 
     * @return Contains information about alarm state changes.
     */
    public final SystemEvent systemEvent() {
        return systemEvent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ruleEvaluation());
        hashCode = 31 * hashCode + Objects.hashCode(customerAction());
        hashCode = 31 * hashCode + Objects.hashCode(systemEvent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmState)) {
            return false;
        }
        AlarmState other = (AlarmState) obj;
        return Objects.equals(stateNameAsString(), other.stateNameAsString())
                && Objects.equals(ruleEvaluation(), other.ruleEvaluation())
                && Objects.equals(customerAction(), other.customerAction()) && Objects.equals(systemEvent(), other.systemEvent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlarmState").add("StateName", stateNameAsString()).add("RuleEvaluation", ruleEvaluation())
                .add("CustomerAction", customerAction()).add("SystemEvent", systemEvent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateName":
            return Optional.ofNullable(clazz.cast(stateNameAsString()));
        case "ruleEvaluation":
            return Optional.ofNullable(clazz.cast(ruleEvaluation()));
        case "customerAction":
            return Optional.ofNullable(clazz.cast(customerAction()));
        case "systemEvent":
            return Optional.ofNullable(clazz.cast(systemEvent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stateName", STATE_NAME_FIELD);
        map.put("ruleEvaluation", RULE_EVALUATION_FIELD);
        map.put("customerAction", CUSTOMER_ACTION_FIELD);
        map.put("systemEvent", SYSTEM_EVENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AlarmState, T> g) {
        return obj -> g.apply((AlarmState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlarmState> {
        /**
         * <p>
         * The name of the alarm state. The state name can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state, it isn't ready to evaluate
         * data. To enable the alarm, you must change the alarm to the <code>NORMAL</code> state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state, it's ready to evaluate data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state, the alarm is invoked.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state, the alarm was invoked
         * and you acknowledged the alarm.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state, the alarm is
         * disabled for a specified period of time. After the snooze time, the alarm automatically changes to the
         * <code>NORMAL</code> state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state, the alarm was invoked. However,
         * the data that the alarm is currently evaluating is within the specified range. To change the alarm to the
         * <code>NORMAL</code> state, you must acknowledge the alarm.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stateName
         *        The name of the alarm state. The state name can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state, it isn't ready to
         *        evaluate data. To enable the alarm, you must change the alarm to the <code>NORMAL</code> state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state, it's ready to evaluate data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state, the alarm is invoked.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state, the alarm was
         *        invoked and you acknowledged the alarm.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state, the alarm
         *        is disabled for a specified period of time. After the snooze time, the alarm automatically changes to
         *        the <code>NORMAL</code> state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state, the alarm was invoked.
         *        However, the data that the alarm is currently evaluating is within the specified range. To change the
         *        alarm to the <code>NORMAL</code> state, you must acknowledge the alarm.
         *        </p>
         *        </li>
         * @see AlarmStateName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlarmStateName
         */
        Builder stateName(String stateName);

        /**
         * <p>
         * The name of the alarm state. The state name can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state, it isn't ready to evaluate
         * data. To enable the alarm, you must change the alarm to the <code>NORMAL</code> state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state, it's ready to evaluate data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state, the alarm is invoked.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state, the alarm was invoked
         * and you acknowledged the alarm.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state, the alarm is
         * disabled for a specified period of time. After the snooze time, the alarm automatically changes to the
         * <code>NORMAL</code> state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state, the alarm was invoked. However,
         * the data that the alarm is currently evaluating is within the specified range. To change the alarm to the
         * <code>NORMAL</code> state, you must acknowledge the alarm.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stateName
         *        The name of the alarm state. The state name can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - When the alarm is in the <code>DISABLED</code> state, it isn't ready to
         *        evaluate data. To enable the alarm, you must change the alarm to the <code>NORMAL</code> state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NORMAL</code> - When the alarm is in the <code>NORMAL</code> state, it's ready to evaluate data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - If the alarm is in the <code>ACTIVE</code> state, the alarm is invoked.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACKNOWLEDGED</code> - When the alarm is in the <code>ACKNOWLEDGED</code> state, the alarm was
         *        invoked and you acknowledged the alarm.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SNOOZE_DISABLED</code> - When the alarm is in the <code>SNOOZE_DISABLED</code> state, the alarm
         *        is disabled for a specified period of time. After the snooze time, the alarm automatically changes to
         *        the <code>NORMAL</code> state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LATCHED</code> - When the alarm is in the <code>LATCHED</code> state, the alarm was invoked.
         *        However, the data that the alarm is currently evaluating is within the specified range. To change the
         *        alarm to the <code>NORMAL</code> state, you must acknowledge the alarm.
         *        </p>
         *        </li>
         * @see AlarmStateName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlarmStateName
         */
        Builder stateName(AlarmStateName stateName);

        /**
         * <p>
         * Information needed to evaluate data.
         * </p>
         * 
         * @param ruleEvaluation
         *        Information needed to evaluate data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleEvaluation(RuleEvaluation ruleEvaluation);

        /**
         * <p>
         * Information needed to evaluate data.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleEvaluation.Builder} avoiding the need
         * to create one manually via {@link RuleEvaluation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleEvaluation.Builder#build()} is called immediately and its
         * result is passed to {@link #ruleEvaluation(RuleEvaluation)}.
         * 
         * @param ruleEvaluation
         *        a consumer that will call methods on {@link RuleEvaluation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleEvaluation(RuleEvaluation)
         */
        default Builder ruleEvaluation(Consumer<RuleEvaluation.Builder> ruleEvaluation) {
            return ruleEvaluation(RuleEvaluation.builder().applyMutation(ruleEvaluation).build());
        }

        /**
         * <p>
         * Contains information about the action that you can take to respond to the alarm.
         * </p>
         * 
         * @param customerAction
         *        Contains information about the action that you can take to respond to the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerAction(CustomerAction customerAction);

        /**
         * <p>
         * Contains information about the action that you can take to respond to the alarm.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomerAction.Builder} avoiding the need
         * to create one manually via {@link CustomerAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerAction.Builder#build()} is called immediately and its
         * result is passed to {@link #customerAction(CustomerAction)}.
         * 
         * @param customerAction
         *        a consumer that will call methods on {@link CustomerAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerAction(CustomerAction)
         */
        default Builder customerAction(Consumer<CustomerAction.Builder> customerAction) {
            return customerAction(CustomerAction.builder().applyMutation(customerAction).build());
        }

        /**
         * <p>
         * Contains information about alarm state changes.
         * </p>
         * 
         * @param systemEvent
         *        Contains information about alarm state changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemEvent(SystemEvent systemEvent);

        /**
         * <p>
         * Contains information about alarm state changes.
         * </p>
         * This is a convenience method that creates an instance of the {@link SystemEvent.Builder} avoiding the need to
         * create one manually via {@link SystemEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SystemEvent.Builder#build()} is called immediately and its result
         * is passed to {@link #systemEvent(SystemEvent)}.
         * 
         * @param systemEvent
         *        a consumer that will call methods on {@link SystemEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #systemEvent(SystemEvent)
         */
        default Builder systemEvent(Consumer<SystemEvent.Builder> systemEvent) {
            return systemEvent(SystemEvent.builder().applyMutation(systemEvent).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String stateName;

        private RuleEvaluation ruleEvaluation;

        private CustomerAction customerAction;

        private SystemEvent systemEvent;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmState model) {
            stateName(model.stateName);
            ruleEvaluation(model.ruleEvaluation);
            customerAction(model.customerAction);
            systemEvent(model.systemEvent);
        }

        public final String getStateName() {
            return stateName;
        }

        public final void setStateName(String stateName) {
            this.stateName = stateName;
        }

        @Override
        public final Builder stateName(String stateName) {
            this.stateName = stateName;
            return this;
        }

        @Override
        public final Builder stateName(AlarmStateName stateName) {
            this.stateName(stateName == null ? null : stateName.toString());
            return this;
        }

        public final RuleEvaluation.Builder getRuleEvaluation() {
            return ruleEvaluation != null ? ruleEvaluation.toBuilder() : null;
        }

        public final void setRuleEvaluation(RuleEvaluation.BuilderImpl ruleEvaluation) {
            this.ruleEvaluation = ruleEvaluation != null ? ruleEvaluation.build() : null;
        }

        @Override
        public final Builder ruleEvaluation(RuleEvaluation ruleEvaluation) {
            this.ruleEvaluation = ruleEvaluation;
            return this;
        }

        public final CustomerAction.Builder getCustomerAction() {
            return customerAction != null ? customerAction.toBuilder() : null;
        }

        public final void setCustomerAction(CustomerAction.BuilderImpl customerAction) {
            this.customerAction = customerAction != null ? customerAction.build() : null;
        }

        @Override
        public final Builder customerAction(CustomerAction customerAction) {
            this.customerAction = customerAction;
            return this;
        }

        public final SystemEvent.Builder getSystemEvent() {
            return systemEvent != null ? systemEvent.toBuilder() : null;
        }

        public final void setSystemEvent(SystemEvent.BuilderImpl systemEvent) {
            this.systemEvent = systemEvent != null ? systemEvent.build() : null;
        }

        @Override
        public final Builder systemEvent(SystemEvent systemEvent) {
            this.systemEvent = systemEvent;
            return this;
        }

        @Override
        public AlarmState build() {
            return new AlarmState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
