/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAlarmResponse extends IotEventsDataResponse implements
        ToCopyableBuilder<DescribeAlarmResponse.Builder, DescribeAlarmResponse> {
    private static final SdkField<Alarm> ALARM_FIELD = SdkField.<Alarm> builder(MarshallingType.SDK_POJO).memberName("alarm")
            .getter(getter(DescribeAlarmResponse::alarm)).setter(setter(Builder::alarm)).constructor(Alarm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarm").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Alarm alarm;

    private DescribeAlarmResponse(BuilderImpl builder) {
        super(builder);
        this.alarm = builder.alarm;
    }

    /**
     * <p>
     * Contains information about an alarm.
     * </p>
     * 
     * @return Contains information about an alarm.
     */
    public final Alarm alarm() {
        return alarm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alarm());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmResponse)) {
            return false;
        }
        DescribeAlarmResponse other = (DescribeAlarmResponse) obj;
        return Objects.equals(alarm(), other.alarm());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAlarmResponse").add("Alarm", alarm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alarm":
            return Optional.ofNullable(clazz.cast(alarm()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("alarm", ALARM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlarmResponse, T> g) {
        return obj -> g.apply((DescribeAlarmResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAlarmResponse> {
        /**
         * <p>
         * Contains information about an alarm.
         * </p>
         * 
         * @param alarm
         *        Contains information about an alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarm(Alarm alarm);

        /**
         * <p>
         * Contains information about an alarm.
         * </p>
         * This is a convenience method that creates an instance of the {@link Alarm.Builder} avoiding the need to
         * create one manually via {@link Alarm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Alarm.Builder#build()} is called immediately and its result is
         * passed to {@link #alarm(Alarm)}.
         * 
         * @param alarm
         *        a consumer that will call methods on {@link Alarm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarm(Alarm)
         */
        default Builder alarm(Consumer<Alarm.Builder> alarm) {
            return alarm(Alarm.builder().applyMutation(alarm).build());
        }
    }

    static final class BuilderImpl extends IotEventsDataResponse.BuilderImpl implements Builder {
        private Alarm alarm;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmResponse model) {
            super(model);
            alarm(model.alarm);
        }

        public final Alarm.Builder getAlarm() {
            return alarm != null ? alarm.toBuilder() : null;
        }

        public final void setAlarm(Alarm.BuilderImpl alarm) {
            this.alarm = alarm != null ? alarm.build() : null;
        }

        @Override
        public final Builder alarm(Alarm alarm) {
            this.alarm = alarm;
            return this;
        }

        @Override
        public DescribeAlarmResponse build() {
            return new DescribeAlarmResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
